/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.MetricDatapoint;

public class MetricDatapointJsonMarshaller {
    private static MetricDatapointJsonMarshaller instance;

    public void marshall(MetricDatapoint metricDatapoint, StructuredJsonGenerator jsonGenerator) {
        if (metricDatapoint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (metricDatapoint.getAverage() != null) {
                jsonGenerator.writeFieldName("average").writeValue(metricDatapoint.getAverage().doubleValue());
            }
            if (metricDatapoint.getMaximum() != null) {
                jsonGenerator.writeFieldName("maximum").writeValue(metricDatapoint.getMaximum().doubleValue());
            }
            if (metricDatapoint.getMinimum() != null) {
                jsonGenerator.writeFieldName("minimum").writeValue(metricDatapoint.getMinimum().doubleValue());
            }
            if (metricDatapoint.getSampleCount() != null) {
                jsonGenerator.writeFieldName("sampleCount").writeValue(metricDatapoint.getSampleCount().doubleValue());
            }
            if (metricDatapoint.getSum() != null) {
                jsonGenerator.writeFieldName("sum").writeValue(metricDatapoint.getSum().doubleValue());
            }
            if (metricDatapoint.getTimestamp() != null) {
                jsonGenerator.writeFieldName("timestamp").writeValue(metricDatapoint.getTimestamp());
            }
            if (metricDatapoint.getUnit() != null) {
                jsonGenerator.writeFieldName("unit").writeValue(metricDatapoint.getUnit());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MetricDatapointJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MetricDatapointJsonMarshaller();
        }
        return instance;
    }
}

