/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.InstanceNetworking;
import com.amazonaws.services.lightsail.model.InstancePortInfo;
import com.amazonaws.services.lightsail.model.transform.InstancePortInfoJsonMarshaller;
import com.amazonaws.services.lightsail.model.transform.MonthlyTransferJsonMarshaller;
import java.util.List;

public class InstanceNetworkingJsonMarshaller {
    private static InstanceNetworkingJsonMarshaller instance;

    public void marshall(InstanceNetworking instanceNetworking, StructuredJsonGenerator jsonGenerator) {
        if (instanceNetworking == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<InstancePortInfo> portsList;
            jsonGenerator.writeStartObject();
            if (instanceNetworking.getMonthlyTransfer() != null) {
                jsonGenerator.writeFieldName("monthlyTransfer");
                MonthlyTransferJsonMarshaller.getInstance().marshall(instanceNetworking.getMonthlyTransfer(), jsonGenerator);
            }
            if ((portsList = instanceNetworking.getPorts()) != null) {
                jsonGenerator.writeFieldName("ports");
                jsonGenerator.writeStartArray();
                for (InstancePortInfo portsListValue : portsList) {
                    if (portsListValue == null) continue;
                    InstancePortInfoJsonMarshaller.getInstance().marshall(portsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceNetworkingJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceNetworkingJsonMarshaller();
        }
        return instance;
    }
}

