/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.NetworkProtocol;
import com.amazonaws.services.lightsail.model.transform.PortInfoMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class PortInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer fromPort;
    private Integer toPort;
    private String protocol;

    public void setFromPort(Integer fromPort) {
        this.fromPort = fromPort;
    }

    public Integer getFromPort() {
        return this.fromPort;
    }

    public PortInfo withFromPort(Integer fromPort) {
        this.setFromPort(fromPort);
        return this;
    }

    public void setToPort(Integer toPort) {
        this.toPort = toPort;
    }

    public Integer getToPort() {
        return this.toPort;
    }

    public PortInfo withToPort(Integer toPort) {
        this.setToPort(toPort);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @JsonProperty(value="protocol")
    public String getProtocol() {
        return this.protocol;
    }

    public PortInfo withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    @JsonIgnore
    public void setProtocol(NetworkProtocol protocol) {
        this.withProtocol(protocol);
    }

    public PortInfo withProtocol(NetworkProtocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFromPort() != null) {
            sb.append("FromPort: ").append(this.getFromPort()).append(",");
        }
        if (this.getToPort() != null) {
            sb.append("ToPort: ").append(this.getToPort()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortInfo)) {
            return false;
        }
        PortInfo other = (PortInfo)obj;
        if (other.getFromPort() == null ^ this.getFromPort() == null) {
            return false;
        }
        if (other.getFromPort() != null && !other.getFromPort().equals(this.getFromPort())) {
            return false;
        }
        if (other.getToPort() == null ^ this.getToPort() == null) {
            return false;
        }
        if (other.getToPort() != null && !other.getToPort().equals(this.getToPort())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        return other.getProtocol() == null || other.getProtocol().equals(this.getProtocol());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFromPort() == null ? 0 : this.getFromPort().hashCode());
        hashCode = 31 * hashCode + (this.getToPort() == null ? 0 : this.getToPort().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        return hashCode;
    }

    public PortInfo clone() {
        try {
            return (PortInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PortInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

