/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.licensemanagerlinuxsubscriptions.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.licensemanagerlinuxsubscriptions.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * RegisteredSubscriptionProviderMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class RegisteredSubscriptionProviderMarshaller {

    private static final MarshallingInfo<String> LASTSUCCESSFULDATARETRIEVALTIME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSuccessfulDataRetrievalTime").build();
    private static final MarshallingInfo<String> SECRETARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SecretArn").build();
    private static final MarshallingInfo<String> SUBSCRIPTIONPROVIDERARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionProviderArn").build();
    private static final MarshallingInfo<String> SUBSCRIPTIONPROVIDERSOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionProviderSource").build();
    private static final MarshallingInfo<String> SUBSCRIPTIONPROVIDERSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionProviderStatus").build();
    private static final MarshallingInfo<String> SUBSCRIPTIONPROVIDERSTATUSMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionProviderStatusMessage").build();

    private static final RegisteredSubscriptionProviderMarshaller instance = new RegisteredSubscriptionProviderMarshaller();

    public static RegisteredSubscriptionProviderMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(RegisteredSubscriptionProvider registeredSubscriptionProvider, ProtocolMarshaller protocolMarshaller) {

        if (registeredSubscriptionProvider == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(registeredSubscriptionProvider.getLastSuccessfulDataRetrievalTime(), LASTSUCCESSFULDATARETRIEVALTIME_BINDING);
            protocolMarshaller.marshall(registeredSubscriptionProvider.getSecretArn(), SECRETARN_BINDING);
            protocolMarshaller.marshall(registeredSubscriptionProvider.getSubscriptionProviderArn(), SUBSCRIPTIONPROVIDERARN_BINDING);
            protocolMarshaller.marshall(registeredSubscriptionProvider.getSubscriptionProviderSource(), SUBSCRIPTIONPROVIDERSOURCE_BINDING);
            protocolMarshaller.marshall(registeredSubscriptionProvider.getSubscriptionProviderStatus(), SUBSCRIPTIONPROVIDERSTATUS_BINDING);
            protocolMarshaller.marshall(registeredSubscriptionProvider.getSubscriptionProviderStatusMessage(), SUBSCRIPTIONPROVIDERSTATUSMESSAGE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
