/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelsv2.model.MessageGroup;
import com.amazonaws.services.lexmodelsv2.model.MessageSelectionStrategy;
import com.amazonaws.services.lexmodelsv2.model.transform.PromptSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PromptSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private List<MessageGroup> messageGroups;
    private Integer maxRetries;
    private Boolean allowInterrupt;
    private String messageSelectionStrategy;

    public List<MessageGroup> getMessageGroups() {
        return this.messageGroups;
    }

    public void setMessageGroups(Collection<MessageGroup> messageGroups) {
        if (messageGroups == null) {
            this.messageGroups = null;
            return;
        }
        this.messageGroups = new ArrayList<MessageGroup>(messageGroups);
    }

    public PromptSpecification withMessageGroups(MessageGroup ... messageGroups) {
        if (this.messageGroups == null) {
            this.setMessageGroups(new ArrayList<MessageGroup>(messageGroups.length));
        }
        for (MessageGroup ele : messageGroups) {
            this.messageGroups.add(ele);
        }
        return this;
    }

    public PromptSpecification withMessageGroups(Collection<MessageGroup> messageGroups) {
        this.setMessageGroups(messageGroups);
        return this;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public PromptSpecification withMaxRetries(Integer maxRetries) {
        this.setMaxRetries(maxRetries);
        return this;
    }

    public void setAllowInterrupt(Boolean allowInterrupt) {
        this.allowInterrupt = allowInterrupt;
    }

    public Boolean getAllowInterrupt() {
        return this.allowInterrupt;
    }

    public PromptSpecification withAllowInterrupt(Boolean allowInterrupt) {
        this.setAllowInterrupt(allowInterrupt);
        return this;
    }

    public Boolean isAllowInterrupt() {
        return this.allowInterrupt;
    }

    public void setMessageSelectionStrategy(String messageSelectionStrategy) {
        this.messageSelectionStrategy = messageSelectionStrategy;
    }

    public String getMessageSelectionStrategy() {
        return this.messageSelectionStrategy;
    }

    public PromptSpecification withMessageSelectionStrategy(String messageSelectionStrategy) {
        this.setMessageSelectionStrategy(messageSelectionStrategy);
        return this;
    }

    public PromptSpecification withMessageSelectionStrategy(MessageSelectionStrategy messageSelectionStrategy) {
        this.messageSelectionStrategy = messageSelectionStrategy.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMessageGroups() != null) {
            sb.append("MessageGroups: ").append(this.getMessageGroups()).append(",");
        }
        if (this.getMaxRetries() != null) {
            sb.append("MaxRetries: ").append(this.getMaxRetries()).append(",");
        }
        if (this.getAllowInterrupt() != null) {
            sb.append("AllowInterrupt: ").append(this.getAllowInterrupt()).append(",");
        }
        if (this.getMessageSelectionStrategy() != null) {
            sb.append("MessageSelectionStrategy: ").append(this.getMessageSelectionStrategy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptSpecification)) {
            return false;
        }
        PromptSpecification other = (PromptSpecification)obj;
        if (other.getMessageGroups() == null ^ this.getMessageGroups() == null) {
            return false;
        }
        if (other.getMessageGroups() != null && !other.getMessageGroups().equals(this.getMessageGroups())) {
            return false;
        }
        if (other.getMaxRetries() == null ^ this.getMaxRetries() == null) {
            return false;
        }
        if (other.getMaxRetries() != null && !other.getMaxRetries().equals(this.getMaxRetries())) {
            return false;
        }
        if (other.getAllowInterrupt() == null ^ this.getAllowInterrupt() == null) {
            return false;
        }
        if (other.getAllowInterrupt() != null && !other.getAllowInterrupt().equals(this.getAllowInterrupt())) {
            return false;
        }
        if (other.getMessageSelectionStrategy() == null ^ this.getMessageSelectionStrategy() == null) {
            return false;
        }
        return other.getMessageSelectionStrategy() == null || other.getMessageSelectionStrategy().equals(this.getMessageSelectionStrategy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMessageGroups() == null ? 0 : this.getMessageGroups().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRetries() == null ? 0 : this.getMaxRetries().hashCode());
        hashCode = 31 * hashCode + (this.getAllowInterrupt() == null ? 0 : this.getAllowInterrupt().hashCode());
        hashCode = 31 * hashCode + (this.getMessageSelectionStrategy() == null ? 0 : this.getMessageSelectionStrategy().hashCode());
        return hashCode;
    }

    public PromptSpecification clone() {
        try {
            return (PromptSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PromptSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

