/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.GetPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetPolicyRequestMarshaller
implements Marshaller<Request<GetPolicyRequest>, GetPolicyRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetPolicyRequest> marshall(GetPolicyRequest getPolicyRequest) {
        if (getPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getPolicyRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/policy";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", getPolicyRequest.getFunctionName() != null ? StringUtils.fromString((String)getPolicyRequest.getFunctionName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (getPolicyRequest.getQualifier() != null) {
            request.addParameter("Qualifier", StringUtils.fromString((String)getPolicyRequest.getQualifier()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

