/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kms.model;

import javax.annotation.Generated;

/**
 * <p>
 * The request was rejected because the specified Amazon VPC endpoint service is already associated with an external key
 * store in the Amazon Web Services account and Region. Each external key store in an Amazon Web Services account and
 * Region must use a different Amazon VPC endpoint service.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class XksProxyVpcEndpointServiceInUseException extends com.amazonaws.services.kms.model.AWSKMSException {
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new XksProxyVpcEndpointServiceInUseException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public XksProxyVpcEndpointServiceInUseException(String message) {
        super(message);
    }

}
