/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideowebrtcstorage;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesisvideowebrtcstorage.AmazonKinesisVideoWebRTCStorageAsync;
import com.amazonaws.services.kinesisvideowebrtcstorage.AmazonKinesisVideoWebRTCStorageAsyncClientBuilder;
import com.amazonaws.services.kinesisvideowebrtcstorage.AmazonKinesisVideoWebRTCStorageClient;
import com.amazonaws.services.kinesisvideowebrtcstorage.model.JoinStorageSessionAsViewerRequest;
import com.amazonaws.services.kinesisvideowebrtcstorage.model.JoinStorageSessionAsViewerResult;
import com.amazonaws.services.kinesisvideowebrtcstorage.model.JoinStorageSessionRequest;
import com.amazonaws.services.kinesisvideowebrtcstorage.model.JoinStorageSessionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonKinesisVideoWebRTCStorageAsyncClient
extends AmazonKinesisVideoWebRTCStorageClient
implements AmazonKinesisVideoWebRTCStorageAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonKinesisVideoWebRTCStorageAsyncClientBuilder asyncBuilder() {
        return AmazonKinesisVideoWebRTCStorageAsyncClientBuilder.standard();
    }

    AmazonKinesisVideoWebRTCStorageAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonKinesisVideoWebRTCStorageAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<JoinStorageSessionResult> joinStorageSessionAsync(JoinStorageSessionRequest request) {
        return this.joinStorageSessionAsync(request, null);
    }

    @Override
    public Future<JoinStorageSessionResult> joinStorageSessionAsync(JoinStorageSessionRequest request, final AsyncHandler<JoinStorageSessionRequest, JoinStorageSessionResult> asyncHandler) {
        final JoinStorageSessionRequest finalRequest = (JoinStorageSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<JoinStorageSessionResult>(){

            @Override
            public JoinStorageSessionResult call() throws Exception {
                JoinStorageSessionResult result = null;
                try {
                    result = AmazonKinesisVideoWebRTCStorageAsyncClient.this.executeJoinStorageSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<JoinStorageSessionAsViewerResult> joinStorageSessionAsViewerAsync(JoinStorageSessionAsViewerRequest request) {
        return this.joinStorageSessionAsViewerAsync(request, null);
    }

    @Override
    public Future<JoinStorageSessionAsViewerResult> joinStorageSessionAsViewerAsync(JoinStorageSessionAsViewerRequest request, final AsyncHandler<JoinStorageSessionAsViewerRequest, JoinStorageSessionAsViewerResult> asyncHandler) {
        final JoinStorageSessionAsViewerRequest finalRequest = (JoinStorageSessionAsViewerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<JoinStorageSessionAsViewerResult>(){

            @Override
            public JoinStorageSessionAsViewerResult call() throws Exception {
                JoinStorageSessionAsViewerResult result = null;
                try {
                    result = AmazonKinesisVideoWebRTCStorageAsyncClient.this.executeJoinStorageSessionAsViewer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

