/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.internal.netty.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PutMediaHandlerInitializer
extends ChannelInitializer<Channel> {
    private static final Log log = LogFactory.getLog(PutMediaHandlerInitializer.class);
    private final SslContext sslContext;
    private final List<ChannelHandler> handlers;
    private final String host;
    private final int port;

    public PutMediaHandlerInitializer(SslContext sslContext, List<ChannelHandler> handlers, String host, int port) {
        this.sslContext = sslContext;
        this.handlers = new ArrayList<ChannelHandler>(handlers);
        this.host = host;
        this.port = port;
    }

    public void initChannel(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        if (log.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler()});
        }
        if (this.sslContext != null) {
            SslHandler sslHandler = this.sslContext.newHandler(channel.alloc(), this.host, this.port);
            this.configureSslEngine(sslHandler.engine());
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
        for (ChannelHandler handler : this.handlers) {
            pipeline.addLast(new ChannelHandler[]{handler});
        }
        pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
    }

    private void configureSslEngine(SSLEngine sslEngine) {
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        sslEngine.setSSLParameters(sslParameters);
    }
}

