/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.MediaStorageConfiguration;

@SdkInternalApi
public class MediaStorageConfigurationMarshaller {
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MediaStorageConfigurationMarshaller instance = new MediaStorageConfigurationMarshaller();

    public static MediaStorageConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(MediaStorageConfiguration mediaStorageConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (mediaStorageConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mediaStorageConfiguration.getStreamARN(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)mediaStorageConfiguration.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

