/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.InputConfiguration;
import com.amazonaws.services.kinesisanalytics.model.transform.InputStartingPositionConfigurationJsonMarshaller;

public class InputConfigurationJsonMarshaller {
    private static InputConfigurationJsonMarshaller instance;

    public void marshall(InputConfiguration inputConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (inputConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (inputConfiguration.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(inputConfiguration.getId());
            }
            if (inputConfiguration.getInputStartingPositionConfiguration() != null) {
                jsonGenerator.writeFieldName("InputStartingPositionConfiguration");
                InputStartingPositionConfigurationJsonMarshaller.getInstance().marshall(inputConfiguration.getInputStartingPositionConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InputConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InputConfigurationJsonMarshaller();
        }
        return instance;
    }
}

