/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kinesis.model.EnhancedMetrics;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class EnhancedMetricsJsonMarshaller {
    private static EnhancedMetricsJsonMarshaller instance;

    public void marshall(EnhancedMetrics enhancedMetrics, StructuredJsonGenerator jsonGenerator) {
        if (enhancedMetrics == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList shardLevelMetricsList = (SdkInternalList)enhancedMetrics.getShardLevelMetrics();
            if (!shardLevelMetricsList.isEmpty() || !shardLevelMetricsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ShardLevelMetrics");
                jsonGenerator.writeStartArray();
                for (String shardLevelMetricsListValue : shardLevelMetricsList) {
                    if (shardLevelMetricsListValue == null) continue;
                    jsonGenerator.writeValue(shardLevelMetricsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EnhancedMetricsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EnhancedMetricsJsonMarshaller();
        }
        return instance;
    }
}

