/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.DeliveryStreamDescription;
import com.amazonaws.services.kinesisfirehose.model.DestinationDescription;
import com.amazonaws.services.kinesisfirehose.model.transform.DestinationDescriptionJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;

public class DeliveryStreamDescriptionJsonMarshaller {
    private static DeliveryStreamDescriptionJsonMarshaller instance;

    public void marshall(DeliveryStreamDescription deliveryStreamDescription, StructuredJsonGenerator jsonGenerator) {
        if (deliveryStreamDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<DestinationDescription> destinationsList;
            jsonGenerator.writeStartObject();
            if (deliveryStreamDescription.getDeliveryStreamName() != null) {
                jsonGenerator.writeFieldName("DeliveryStreamName").writeValue(deliveryStreamDescription.getDeliveryStreamName());
            }
            if (deliveryStreamDescription.getDeliveryStreamARN() != null) {
                jsonGenerator.writeFieldName("DeliveryStreamARN").writeValue(deliveryStreamDescription.getDeliveryStreamARN());
            }
            if (deliveryStreamDescription.getDeliveryStreamStatus() != null) {
                jsonGenerator.writeFieldName("DeliveryStreamStatus").writeValue(deliveryStreamDescription.getDeliveryStreamStatus());
            }
            if (deliveryStreamDescription.getVersionId() != null) {
                jsonGenerator.writeFieldName("VersionId").writeValue(deliveryStreamDescription.getVersionId());
            }
            if (deliveryStreamDescription.getCreateTimestamp() != null) {
                jsonGenerator.writeFieldName("CreateTimestamp").writeValue(deliveryStreamDescription.getCreateTimestamp());
            }
            if (deliveryStreamDescription.getLastUpdateTimestamp() != null) {
                jsonGenerator.writeFieldName("LastUpdateTimestamp").writeValue(deliveryStreamDescription.getLastUpdateTimestamp());
            }
            if ((destinationsList = deliveryStreamDescription.getDestinations()) != null) {
                jsonGenerator.writeFieldName("Destinations");
                jsonGenerator.writeStartArray();
                for (DestinationDescription destinationsListValue : destinationsList) {
                    if (destinationsListValue == null) continue;
                    DestinationDescriptionJsonMarshaller.getInstance().marshall(destinationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (deliveryStreamDescription.getHasMoreDestinations() != null) {
                jsonGenerator.writeFieldName("HasMoreDestinations").writeValue(deliveryStreamDescription.getHasMoreDestinations().booleanValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeliveryStreamDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeliveryStreamDescriptionJsonMarshaller();
        }
        return instance;
    }
}

