/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.util.json.SdkJsonGenerator;

public class RecordJsonMarshaller {
    private static RecordJsonMarshaller instance;

    public void marshall(Record record, SdkJsonGenerator jsonGenerator) {
        if (record == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (record.getSequenceNumber() != null) {
                jsonGenerator.writeFieldName("SequenceNumber").writeValue(record.getSequenceNumber());
            }
            if (record.getApproximateArrivalTimestamp() != null) {
                jsonGenerator.writeFieldName("ApproximateArrivalTimestamp").writeValue(record.getApproximateArrivalTimestamp());
            }
            if (record.getData() != null) {
                jsonGenerator.writeFieldName("Data").writeValue(record.getData());
            }
            if (record.getPartitionKey() != null) {
                jsonGenerator.writeFieldName("PartitionKey").writeValue(record.getPartitionKey());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecordJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecordJsonMarshaller();
        }
        return instance;
    }
}

