/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.keyspaces.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.keyspaces.model.KeyspaceSummary;
import java.util.List;

@SdkInternalApi
public class KeyspaceSummaryMarshaller {
    private static final MarshallingInfo<String> KEYSPACENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyspaceName").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceArn").build();
    private static final MarshallingInfo<String> REPLICATIONSTRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationStrategy").build();
    private static final MarshallingInfo<List> REPLICATIONREGIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationRegions").build();
    private static final KeyspaceSummaryMarshaller instance = new KeyspaceSummaryMarshaller();

    public static KeyspaceSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(KeyspaceSummary keyspaceSummary, ProtocolMarshaller protocolMarshaller) {
        if (keyspaceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)keyspaceSummary.getKeyspaceName(), KEYSPACENAME_BINDING);
            protocolMarshaller.marshall((Object)keyspaceSummary.getResourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)keyspaceSummary.getReplicationStrategy(), REPLICATIONSTRATEGY_BINDING);
            protocolMarshaller.marshall(keyspaceSummary.getReplicationRegions(), REPLICATIONREGIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

