/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.keyspaces.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.keyspaces.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetKeyspaceResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetKeyspaceResultJsonUnmarshaller implements Unmarshaller<GetKeyspaceResult, JsonUnmarshallerContext> {

    public GetKeyspaceResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetKeyspaceResult getKeyspaceResult = new GetKeyspaceResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getKeyspaceResult;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("keyspaceName", targetDepth)) {
                    context.nextToken();
                    getKeyspaceResult.setKeyspaceName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("resourceArn", targetDepth)) {
                    context.nextToken();
                    getKeyspaceResult.setResourceArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("replicationStrategy", targetDepth)) {
                    context.nextToken();
                    getKeyspaceResult.setReplicationStrategy(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("replicationRegions", targetDepth)) {
                    context.nextToken();
                    getKeyspaceResult.setReplicationRegions(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getKeyspaceResult;
    }

    private static GetKeyspaceResultJsonUnmarshaller instance;

    public static GetKeyspaceResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new GetKeyspaceResultJsonUnmarshaller();
        return instance;
    }
}
