/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.keyspaces.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The client-side timestamp setting of the table.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/client-side-timestamps-how-it-works.html">How it works:
 * Amazon Keyspaces client-side timestamps</a> in the <i>Amazon Keyspaces Developer Guide</i>.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/ClientSideTimestamps" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ClientSideTimestamps implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Shows how to enable client-side timestamps settings for the specified table.
     * </p>
     */
    private String status;

    /**
     * <p>
     * Shows how to enable client-side timestamps settings for the specified table.
     * </p>
     * 
     * @param status
     *        Shows how to enable client-side timestamps settings for the specified table.
     * @see ClientSideTimestampsStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Shows how to enable client-side timestamps settings for the specified table.
     * </p>
     * 
     * @return Shows how to enable client-side timestamps settings for the specified table.
     * @see ClientSideTimestampsStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Shows how to enable client-side timestamps settings for the specified table.
     * </p>
     * 
     * @param status
     *        Shows how to enable client-side timestamps settings for the specified table.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ClientSideTimestampsStatus
     */

    public ClientSideTimestamps withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * Shows how to enable client-side timestamps settings for the specified table.
     * </p>
     * 
     * @param status
     *        Shows how to enable client-side timestamps settings for the specified table.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ClientSideTimestampsStatus
     */

    public ClientSideTimestamps withStatus(ClientSideTimestampsStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ClientSideTimestamps == false)
            return false;
        ClientSideTimestamps other = (ClientSideTimestamps) obj;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        return hashCode;
    }

    @Override
    public ClientSideTimestamps clone() {
        try {
            return (ClientSideTimestamps) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.keyspaces.model.transform.ClientSideTimestampsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
