/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kendraranking.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/ListRescoreExecutionPlans"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListRescoreExecutionPlansResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * An array of summary information for one or more rescore execution plans.
     * </p>
     */
    private java.util.List<RescoreExecutionPlanSummary> summaryItems;
    /**
     * <p>
     * If the response is truncated, Amazon Kendra Intelligent Ranking returns a pagination token in the response.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * An array of summary information for one or more rescore execution plans.
     * </p>
     * 
     * @return An array of summary information for one or more rescore execution plans.
     */

    public java.util.List<RescoreExecutionPlanSummary> getSummaryItems() {
        return summaryItems;
    }

    /**
     * <p>
     * An array of summary information for one or more rescore execution plans.
     * </p>
     * 
     * @param summaryItems
     *        An array of summary information for one or more rescore execution plans.
     */

    public void setSummaryItems(java.util.Collection<RescoreExecutionPlanSummary> summaryItems) {
        if (summaryItems == null) {
            this.summaryItems = null;
            return;
        }

        this.summaryItems = new java.util.ArrayList<RescoreExecutionPlanSummary>(summaryItems);
    }

    /**
     * <p>
     * An array of summary information for one or more rescore execution plans.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSummaryItems(java.util.Collection)} or {@link #withSummaryItems(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param summaryItems
     *        An array of summary information for one or more rescore execution plans.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRescoreExecutionPlansResult withSummaryItems(RescoreExecutionPlanSummary... summaryItems) {
        if (this.summaryItems == null) {
            setSummaryItems(new java.util.ArrayList<RescoreExecutionPlanSummary>(summaryItems.length));
        }
        for (RescoreExecutionPlanSummary ele : summaryItems) {
            this.summaryItems.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of summary information for one or more rescore execution plans.
     * </p>
     * 
     * @param summaryItems
     *        An array of summary information for one or more rescore execution plans.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRescoreExecutionPlansResult withSummaryItems(java.util.Collection<RescoreExecutionPlanSummary> summaryItems) {
        setSummaryItems(summaryItems);
        return this;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Kendra Intelligent Ranking returns a pagination token in the response.
     * </p>
     * 
     * @param nextToken
     *        If the response is truncated, Amazon Kendra Intelligent Ranking returns a pagination token in the
     *        response.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Kendra Intelligent Ranking returns a pagination token in the response.
     * </p>
     * 
     * @return If the response is truncated, Amazon Kendra Intelligent Ranking returns a pagination token in the
     *         response.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Kendra Intelligent Ranking returns a pagination token in the response.
     * </p>
     * 
     * @param nextToken
     *        If the response is truncated, Amazon Kendra Intelligent Ranking returns a pagination token in the
     *        response.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListRescoreExecutionPlansResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSummaryItems() != null)
            sb.append("SummaryItems: ").append(getSummaryItems()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListRescoreExecutionPlansResult == false)
            return false;
        ListRescoreExecutionPlansResult other = (ListRescoreExecutionPlansResult) obj;
        if (other.getSummaryItems() == null ^ this.getSummaryItems() == null)
            return false;
        if (other.getSummaryItems() != null && other.getSummaryItems().equals(this.getSummaryItems()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSummaryItems() == null) ? 0 : getSummaryItems().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListRescoreExecutionPlansResult clone() {
        try {
            return (ListRescoreExecutionPlansResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
