/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kendra.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Provides the configuration information for crawling knowledge articles in the ServiceNow site.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/ServiceNowKnowledgeArticleConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ServiceNowKnowledgeArticleConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * <code>TRUE</code> to index attachments to knowledge articles.
     * </p>
     */
    private Boolean crawlAttachments;
    /**
     * <p>
     * A list of regular expression patterns applied to include knowledge article attachments. Attachments that match
     * the patterns are included in the index. Items that don't match the patterns are excluded from the index. If an
     * item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't
     * included in the index.
     * </p>
     */
    private java.util.List<String> includeAttachmentFilePatterns;
    /**
     * <p>
     * A list of regular expression patterns applied to exclude certain knowledge article attachments. Attachments that
     * match the patterns are excluded from the index. Items that don't match the patterns are included in the index. If
     * an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item
     * isn't included in the index.
     * </p>
     */
    private java.util.List<String> excludeAttachmentFilePatterns;
    /**
     * <p>
     * The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index.
     * </p>
     */
    private String documentDataFieldName;
    /**
     * <p>
     * The name of the ServiceNow field that is mapped to the index document title field.
     * </p>
     */
    private String documentTitleFieldName;
    /**
     * <p>
     * Maps attributes or field names of knoweldge articles to Amazon Kendra index field names. To create custom fields,
     * use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
     * ServiceNow data source field names must exist in your ServiceNow custom metadata.
     * </p>
     */
    private java.util.List<DataSourceToIndexFieldMapping> fieldMappings;
    /**
     * <p>
     * A query that selects the knowledge articles to index. The query can return articles from multiple knowledge
     * bases, and the knowledge bases can be public or private.
     * </p>
     * <p>
     * The query string must be one generated by the ServiceNow console. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying documents to index with a
     * query</a>.
     * </p>
     */
    private String filterQuery;

    /**
     * <p>
     * <code>TRUE</code> to index attachments to knowledge articles.
     * </p>
     * 
     * @param crawlAttachments
     *        <code>TRUE</code> to index attachments to knowledge articles.
     */

    public void setCrawlAttachments(Boolean crawlAttachments) {
        this.crawlAttachments = crawlAttachments;
    }

    /**
     * <p>
     * <code>TRUE</code> to index attachments to knowledge articles.
     * </p>
     * 
     * @return <code>TRUE</code> to index attachments to knowledge articles.
     */

    public Boolean getCrawlAttachments() {
        return this.crawlAttachments;
    }

    /**
     * <p>
     * <code>TRUE</code> to index attachments to knowledge articles.
     * </p>
     * 
     * @param crawlAttachments
     *        <code>TRUE</code> to index attachments to knowledge articles.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceNowKnowledgeArticleConfiguration withCrawlAttachments(Boolean crawlAttachments) {
        setCrawlAttachments(crawlAttachments);
        return this;
    }

    /**
     * <p>
     * <code>TRUE</code> to index attachments to knowledge articles.
     * </p>
     * 
     * @return <code>TRUE</code> to index attachments to knowledge articles.
     */

    public Boolean isCrawlAttachments() {
        return this.crawlAttachments;
    }

    /**
     * <p>
     * A list of regular expression patterns applied to include knowledge article attachments. Attachments that match
     * the patterns are included in the index. Items that don't match the patterns are excluded from the index. If an
     * item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't
     * included in the index.
     * </p>
     * 
     * @return A list of regular expression patterns applied to include knowledge article attachments. Attachments that
     *         match the patterns are included in the index. Items that don't match the patterns are excluded from the
     *         index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence
     *         and the item isn't included in the index.
     */

    public java.util.List<String> getIncludeAttachmentFilePatterns() {
        return includeAttachmentFilePatterns;
    }

    /**
     * <p>
     * A list of regular expression patterns applied to include knowledge article attachments. Attachments that match
     * the patterns are included in the index. Items that don't match the patterns are excluded from the index. If an
     * item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't
     * included in the index.
     * </p>
     * 
     * @param includeAttachmentFilePatterns
     *        A list of regular expression patterns applied to include knowledge article attachments. Attachments that
     *        match the patterns are included in the index. Items that don't match the patterns are excluded from the
     *        index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence
     *        and the item isn't included in the index.
     */

    public void setIncludeAttachmentFilePatterns(java.util.Collection<String> includeAttachmentFilePatterns) {
        if (includeAttachmentFilePatterns == null) {
            this.includeAttachmentFilePatterns = null;
            return;
        }

        this.includeAttachmentFilePatterns = new java.util.ArrayList<String>(includeAttachmentFilePatterns);
    }

    /**
     * <p>
     * A list of regular expression patterns applied to include knowledge article attachments. Attachments that match
     * the patterns are included in the index. Items that don't match the patterns are excluded from the index. If an
     * item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't
     * included in the index.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setIncludeAttachmentFilePatterns(java.util.Collection)} or
     * {@link #withIncludeAttachmentFilePatterns(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param includeAttachmentFilePatterns
     *        A list of regular expression patterns applied to include knowledge article attachments. Attachments that
     *        match the patterns are included in the index. Items that don't match the patterns are excluded from the
     *        index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence
     *        and the item isn't included in the index.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceNowKnowledgeArticleConfiguration withIncludeAttachmentFilePatterns(String... includeAttachmentFilePatterns) {
        if (this.includeAttachmentFilePatterns == null) {
            setIncludeAttachmentFilePatterns(new java.util.ArrayList<String>(includeAttachmentFilePatterns.length));
        }
        for (String ele : includeAttachmentFilePatterns) {
            this.includeAttachmentFilePatterns.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of regular expression patterns applied to include knowledge article attachments. Attachments that match
     * the patterns are included in the index. Items that don't match the patterns are excluded from the index. If an
     * item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't
     * included in the index.
     * </p>
     * 
     * @param includeAttachmentFilePatterns
     *        A list of regular expression patterns applied to include knowledge article attachments. Attachments that
     *        match the patterns are included in the index. Items that don't match the patterns are excluded from the
     *        index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence
     *        and the item isn't included in the index.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceNowKnowledgeArticleConfiguration withIncludeAttachmentFilePatterns(java.util.Collection<String> includeAttachmentFilePatterns) {
        setIncludeAttachmentFilePatterns(includeAttachmentFilePatterns);
        return this;
    }

    /**
     * <p>
     * A list of regular expression patterns applied to exclude certain knowledge article attachments. Attachments that
     * match the patterns are excluded from the index. Items that don't match the patterns are included in the index. If
     * an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item
     * isn't included in the index.
     * </p>
     * 
     * @return A list of regular expression patterns applied to exclude certain knowledge article attachments.
     *         Attachments that match the patterns are excluded from the index. Items that don't match the patterns are
     *         included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern
     *         takes precedence and the item isn't included in the index.
     */

    public java.util.List<String> getExcludeAttachmentFilePatterns() {
        return excludeAttachmentFilePatterns;
    }

    /**
     * <p>
     * A list of regular expression patterns applied to exclude certain knowledge article attachments. Attachments that
     * match the patterns are excluded from the index. Items that don't match the patterns are included in the index. If
     * an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item
     * isn't included in the index.
     * </p>
     * 
     * @param excludeAttachmentFilePatterns
     *        A list of regular expression patterns applied to exclude certain knowledge article attachments.
     *        Attachments that match the patterns are excluded from the index. Items that don't match the patterns are
     *        included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern
     *        takes precedence and the item isn't included in the index.
     */

    public void setExcludeAttachmentFilePatterns(java.util.Collection<String> excludeAttachmentFilePatterns) {
        if (excludeAttachmentFilePatterns == null) {
            this.excludeAttachmentFilePatterns = null;
            return;
        }

        this.excludeAttachmentFilePatterns = new java.util.ArrayList<String>(excludeAttachmentFilePatterns);
    }

    /**
     * <p>
     * A list of regular expression patterns applied to exclude certain knowledge article attachments. Attachments that
     * match the patterns are excluded from the index. Items that don't match the patterns are included in the index. If
     * an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item
     * isn't included in the index.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setExcludeAttachmentFilePatterns(java.util.Collection)} or
     * {@link #withExcludeAttachmentFilePatterns(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param excludeAttachmentFilePatterns
     *        A list of regular expression patterns applied to exclude certain knowledge article attachments.
     *        Attachments that match the patterns are excluded from the index. Items that don't match the patterns are
     *        included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern
     *        takes precedence and the item isn't included in the index.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceNowKnowledgeArticleConfiguration withExcludeAttachmentFilePatterns(String... excludeAttachmentFilePatterns) {
        if (this.excludeAttachmentFilePatterns == null) {
            setExcludeAttachmentFilePatterns(new java.util.ArrayList<String>(excludeAttachmentFilePatterns.length));
        }
        for (String ele : excludeAttachmentFilePatterns) {
            this.excludeAttachmentFilePatterns.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of regular expression patterns applied to exclude certain knowledge article attachments. Attachments that
     * match the patterns are excluded from the index. Items that don't match the patterns are included in the index. If
     * an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item
     * isn't included in the index.
     * </p>
     * 
     * @param excludeAttachmentFilePatterns
     *        A list of regular expression patterns applied to exclude certain knowledge article attachments.
     *        Attachments that match the patterns are excluded from the index. Items that don't match the patterns are
     *        included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern
     *        takes precedence and the item isn't included in the index.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceNowKnowledgeArticleConfiguration withExcludeAttachmentFilePatterns(java.util.Collection<String> excludeAttachmentFilePatterns) {
        setExcludeAttachmentFilePatterns(excludeAttachmentFilePatterns);
        return this;
    }

    /**
     * <p>
     * The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index.
     * </p>
     * 
     * @param documentDataFieldName
     *        The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra
     *        index.
     */

    public void setDocumentDataFieldName(String documentDataFieldName) {
        this.documentDataFieldName = documentDataFieldName;
    }

    /**
     * <p>
     * The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index.
     * </p>
     * 
     * @return The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra
     *         index.
     */

    public String getDocumentDataFieldName() {
        return this.documentDataFieldName;
    }

    /**
     * <p>
     * The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index.
     * </p>
     * 
     * @param documentDataFieldName
     *        The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra
     *        index.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceNowKnowledgeArticleConfiguration withDocumentDataFieldName(String documentDataFieldName) {
        setDocumentDataFieldName(documentDataFieldName);
        return this;
    }

    /**
     * <p>
     * The name of the ServiceNow field that is mapped to the index document title field.
     * </p>
     * 
     * @param documentTitleFieldName
     *        The name of the ServiceNow field that is mapped to the index document title field.
     */

    public void setDocumentTitleFieldName(String documentTitleFieldName) {
        this.documentTitleFieldName = documentTitleFieldName;
    }

    /**
     * <p>
     * The name of the ServiceNow field that is mapped to the index document title field.
     * </p>
     * 
     * @return The name of the ServiceNow field that is mapped to the index document title field.
     */

    public String getDocumentTitleFieldName() {
        return this.documentTitleFieldName;
    }

    /**
     * <p>
     * The name of the ServiceNow field that is mapped to the index document title field.
     * </p>
     * 
     * @param documentTitleFieldName
     *        The name of the ServiceNow field that is mapped to the index document title field.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceNowKnowledgeArticleConfiguration withDocumentTitleFieldName(String documentTitleFieldName) {
        setDocumentTitleFieldName(documentTitleFieldName);
        return this;
    }

    /**
     * <p>
     * Maps attributes or field names of knoweldge articles to Amazon Kendra index field names. To create custom fields,
     * use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
     * ServiceNow data source field names must exist in your ServiceNow custom metadata.
     * </p>
     * 
     * @return Maps attributes or field names of knoweldge articles to Amazon Kendra index field names. To create custom
     *         fields, use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information,
     *         see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source
     *         fields</a>. The ServiceNow data source field names must exist in your ServiceNow custom metadata.
     */

    public java.util.List<DataSourceToIndexFieldMapping> getFieldMappings() {
        return fieldMappings;
    }

    /**
     * <p>
     * Maps attributes or field names of knoweldge articles to Amazon Kendra index field names. To create custom fields,
     * use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
     * ServiceNow data source field names must exist in your ServiceNow custom metadata.
     * </p>
     * 
     * @param fieldMappings
     *        Maps attributes or field names of knoweldge articles to Amazon Kendra index field names. To create custom
     *        fields, use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information,
     *        see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source
     *        fields</a>. The ServiceNow data source field names must exist in your ServiceNow custom metadata.
     */

    public void setFieldMappings(java.util.Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        if (fieldMappings == null) {
            this.fieldMappings = null;
            return;
        }

        this.fieldMappings = new java.util.ArrayList<DataSourceToIndexFieldMapping>(fieldMappings);
    }

    /**
     * <p>
     * Maps attributes or field names of knoweldge articles to Amazon Kendra index field names. To create custom fields,
     * use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
     * ServiceNow data source field names must exist in your ServiceNow custom metadata.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFieldMappings(java.util.Collection)} or {@link #withFieldMappings(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param fieldMappings
     *        Maps attributes or field names of knoweldge articles to Amazon Kendra index field names. To create custom
     *        fields, use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information,
     *        see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source
     *        fields</a>. The ServiceNow data source field names must exist in your ServiceNow custom metadata.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceNowKnowledgeArticleConfiguration withFieldMappings(DataSourceToIndexFieldMapping... fieldMappings) {
        if (this.fieldMappings == null) {
            setFieldMappings(new java.util.ArrayList<DataSourceToIndexFieldMapping>(fieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : fieldMappings) {
            this.fieldMappings.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Maps attributes or field names of knoweldge articles to Amazon Kendra index field names. To create custom fields,
     * use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a>. The
     * ServiceNow data source field names must exist in your ServiceNow custom metadata.
     * </p>
     * 
     * @param fieldMappings
     *        Maps attributes or field names of knoweldge articles to Amazon Kendra index field names. To create custom
     *        fields, use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information,
     *        see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source
     *        fields</a>. The ServiceNow data source field names must exist in your ServiceNow custom metadata.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceNowKnowledgeArticleConfiguration withFieldMappings(java.util.Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        setFieldMappings(fieldMappings);
        return this;
    }

    /**
     * <p>
     * A query that selects the knowledge articles to index. The query can return articles from multiple knowledge
     * bases, and the knowledge bases can be public or private.
     * </p>
     * <p>
     * The query string must be one generated by the ServiceNow console. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying documents to index with a
     * query</a>.
     * </p>
     * 
     * @param filterQuery
     *        A query that selects the knowledge articles to index. The query can return articles from multiple
     *        knowledge bases, and the knowledge bases can be public or private.</p>
     *        <p>
     *        The query string must be one generated by the ServiceNow console. For more information, see <a
     *        href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying documents to index
     *        with a query</a>.
     */

    public void setFilterQuery(String filterQuery) {
        this.filterQuery = filterQuery;
    }

    /**
     * <p>
     * A query that selects the knowledge articles to index. The query can return articles from multiple knowledge
     * bases, and the knowledge bases can be public or private.
     * </p>
     * <p>
     * The query string must be one generated by the ServiceNow console. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying documents to index with a
     * query</a>.
     * </p>
     * 
     * @return A query that selects the knowledge articles to index. The query can return articles from multiple
     *         knowledge bases, and the knowledge bases can be public or private.</p>
     *         <p>
     *         The query string must be one generated by the ServiceNow console. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying documents to index
     *         with a query</a>.
     */

    public String getFilterQuery() {
        return this.filterQuery;
    }

    /**
     * <p>
     * A query that selects the knowledge articles to index. The query can return articles from multiple knowledge
     * bases, and the knowledge bases can be public or private.
     * </p>
     * <p>
     * The query string must be one generated by the ServiceNow console. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying documents to index with a
     * query</a>.
     * </p>
     * 
     * @param filterQuery
     *        A query that selects the knowledge articles to index. The query can return articles from multiple
     *        knowledge bases, and the knowledge bases can be public or private.</p>
     *        <p>
     *        The query string must be one generated by the ServiceNow console. For more information, see <a
     *        href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying documents to index
     *        with a query</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceNowKnowledgeArticleConfiguration withFilterQuery(String filterQuery) {
        setFilterQuery(filterQuery);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCrawlAttachments() != null)
            sb.append("CrawlAttachments: ").append(getCrawlAttachments()).append(",");
        if (getIncludeAttachmentFilePatterns() != null)
            sb.append("IncludeAttachmentFilePatterns: ").append(getIncludeAttachmentFilePatterns()).append(",");
        if (getExcludeAttachmentFilePatterns() != null)
            sb.append("ExcludeAttachmentFilePatterns: ").append(getExcludeAttachmentFilePatterns()).append(",");
        if (getDocumentDataFieldName() != null)
            sb.append("DocumentDataFieldName: ").append(getDocumentDataFieldName()).append(",");
        if (getDocumentTitleFieldName() != null)
            sb.append("DocumentTitleFieldName: ").append(getDocumentTitleFieldName()).append(",");
        if (getFieldMappings() != null)
            sb.append("FieldMappings: ").append(getFieldMappings()).append(",");
        if (getFilterQuery() != null)
            sb.append("FilterQuery: ").append(getFilterQuery());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ServiceNowKnowledgeArticleConfiguration == false)
            return false;
        ServiceNowKnowledgeArticleConfiguration other = (ServiceNowKnowledgeArticleConfiguration) obj;
        if (other.getCrawlAttachments() == null ^ this.getCrawlAttachments() == null)
            return false;
        if (other.getCrawlAttachments() != null && other.getCrawlAttachments().equals(this.getCrawlAttachments()) == false)
            return false;
        if (other.getIncludeAttachmentFilePatterns() == null ^ this.getIncludeAttachmentFilePatterns() == null)
            return false;
        if (other.getIncludeAttachmentFilePatterns() != null
                && other.getIncludeAttachmentFilePatterns().equals(this.getIncludeAttachmentFilePatterns()) == false)
            return false;
        if (other.getExcludeAttachmentFilePatterns() == null ^ this.getExcludeAttachmentFilePatterns() == null)
            return false;
        if (other.getExcludeAttachmentFilePatterns() != null
                && other.getExcludeAttachmentFilePatterns().equals(this.getExcludeAttachmentFilePatterns()) == false)
            return false;
        if (other.getDocumentDataFieldName() == null ^ this.getDocumentDataFieldName() == null)
            return false;
        if (other.getDocumentDataFieldName() != null && other.getDocumentDataFieldName().equals(this.getDocumentDataFieldName()) == false)
            return false;
        if (other.getDocumentTitleFieldName() == null ^ this.getDocumentTitleFieldName() == null)
            return false;
        if (other.getDocumentTitleFieldName() != null && other.getDocumentTitleFieldName().equals(this.getDocumentTitleFieldName()) == false)
            return false;
        if (other.getFieldMappings() == null ^ this.getFieldMappings() == null)
            return false;
        if (other.getFieldMappings() != null && other.getFieldMappings().equals(this.getFieldMappings()) == false)
            return false;
        if (other.getFilterQuery() == null ^ this.getFilterQuery() == null)
            return false;
        if (other.getFilterQuery() != null && other.getFilterQuery().equals(this.getFilterQuery()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCrawlAttachments() == null) ? 0 : getCrawlAttachments().hashCode());
        hashCode = prime * hashCode + ((getIncludeAttachmentFilePatterns() == null) ? 0 : getIncludeAttachmentFilePatterns().hashCode());
        hashCode = prime * hashCode + ((getExcludeAttachmentFilePatterns() == null) ? 0 : getExcludeAttachmentFilePatterns().hashCode());
        hashCode = prime * hashCode + ((getDocumentDataFieldName() == null) ? 0 : getDocumentDataFieldName().hashCode());
        hashCode = prime * hashCode + ((getDocumentTitleFieldName() == null) ? 0 : getDocumentTitleFieldName().hashCode());
        hashCode = prime * hashCode + ((getFieldMappings() == null) ? 0 : getFieldMappings().hashCode());
        hashCode = prime * hashCode + ((getFilterQuery() == null) ? 0 : getFilterQuery().hashCode());
        return hashCode;
    }

    @Override
    public ServiceNowKnowledgeArticleConfiguration clone() {
        try {
            return (ServiceNowKnowledgeArticleConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.kendra.model.transform.ServiceNowKnowledgeArticleConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
