/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.KafkaClusterSummary;

@SdkInternalApi
public class KafkaClusterSummaryMarshaller {
    private static final MarshallingInfo<StructuredPojo> AMAZONMSKCLUSTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amazonMskCluster").build();
    private static final MarshallingInfo<String> KAFKACLUSTERALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kafkaClusterAlias").build();
    private static final KafkaClusterSummaryMarshaller instance = new KafkaClusterSummaryMarshaller();

    public static KafkaClusterSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(KafkaClusterSummary kafkaClusterSummary, ProtocolMarshaller protocolMarshaller) {
        if (kafkaClusterSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)kafkaClusterSummary.getAmazonMskCluster(), AMAZONMSKCLUSTER_BINDING);
            protocolMarshaller.marshall((Object)kafkaClusterSummary.getKafkaClusterAlias(), KAFKACLUSTERALIAS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

