/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kafka;

import javax.annotation.Generated;

import com.amazonaws.services.kafka.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSKafka}. Convenient method forms pass through to the corresponding overload that
 * takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSKafka implements AWSKafka {

    protected AbstractAWSKafka() {
    }

    @Override
    public BatchAssociateScramSecretResult batchAssociateScramSecret(BatchAssociateScramSecretRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDisassociateScramSecretResult batchDisassociateScramSecret(BatchDisassociateScramSecretRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateClusterResult createCluster(CreateClusterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateClusterV2Result createClusterV2(CreateClusterV2Request request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConfigurationResult createConfiguration(CreateConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateReplicatorResult createReplicator(CreateReplicatorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVpcConnectionResult createVpcConnection(CreateVpcConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteClusterResult deleteCluster(DeleteClusterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteClusterPolicyResult deleteClusterPolicy(DeleteClusterPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConfigurationResult deleteConfiguration(DeleteConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteReplicatorResult deleteReplicator(DeleteReplicatorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVpcConnectionResult deleteVpcConnection(DeleteVpcConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeClusterResult describeCluster(DescribeClusterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeClusterOperationResult describeClusterOperation(DescribeClusterOperationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeClusterOperationV2Result describeClusterOperationV2(DescribeClusterOperationV2Request request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeClusterV2Result describeClusterV2(DescribeClusterV2Request request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeConfigurationResult describeConfiguration(DescribeConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeConfigurationRevisionResult describeConfigurationRevision(DescribeConfigurationRevisionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeReplicatorResult describeReplicator(DescribeReplicatorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeVpcConnectionResult describeVpcConnection(DescribeVpcConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBootstrapBrokersResult getBootstrapBrokers(GetBootstrapBrokersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetClusterPolicyResult getClusterPolicy(GetClusterPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCompatibleKafkaVersionsResult getCompatibleKafkaVersions(GetCompatibleKafkaVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListClientVpcConnectionsResult listClientVpcConnections(ListClientVpcConnectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListClusterOperationsResult listClusterOperations(ListClusterOperationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListClusterOperationsV2Result listClusterOperationsV2(ListClusterOperationsV2Request request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListClustersResult listClusters(ListClustersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListClustersV2Result listClustersV2(ListClustersV2Request request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConfigurationRevisionsResult listConfigurationRevisions(ListConfigurationRevisionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConfigurationsResult listConfigurations(ListConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListKafkaVersionsResult listKafkaVersions(ListKafkaVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNodesResult listNodes(ListNodesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReplicatorsResult listReplicators(ListReplicatorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListScramSecretsResult listScramSecrets(ListScramSecretsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVpcConnectionsResult listVpcConnections(ListVpcConnectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutClusterPolicyResult putClusterPolicy(PutClusterPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RebootBrokerResult rebootBroker(RebootBrokerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectClientVpcConnectionResult rejectClientVpcConnection(RejectClientVpcConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBrokerCountResult updateBrokerCount(UpdateBrokerCountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBrokerStorageResult updateBrokerStorage(UpdateBrokerStorageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBrokerTypeResult updateBrokerType(UpdateBrokerTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateClusterConfigurationResult updateClusterConfiguration(UpdateClusterConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateClusterKafkaVersionResult updateClusterKafkaVersion(UpdateClusterKafkaVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConfigurationResult updateConfiguration(UpdateConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConnectivityResult updateConnectivity(UpdateConnectivityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMonitoringResult updateMonitoring(UpdateMonitoringRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateReplicationInfoResult updateReplicationInfo(UpdateReplicationInfoRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSecurityResult updateSecurity(UpdateSecurityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateStorageResult updateStorage(UpdateStorageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
