/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivsrealtime.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.ivsrealtime.model.CompositionSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCompositionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<CompositionSummary> compositions;
    private String nextToken;

    public List<CompositionSummary> getCompositions() {
        return this.compositions;
    }

    public void setCompositions(Collection<CompositionSummary> compositions) {
        if (compositions == null) {
            this.compositions = null;
            return;
        }
        this.compositions = new ArrayList<CompositionSummary>(compositions);
    }

    public ListCompositionsResult withCompositions(CompositionSummary ... compositions) {
        if (this.compositions == null) {
            this.setCompositions(new ArrayList<CompositionSummary>(compositions.length));
        }
        for (CompositionSummary ele : compositions) {
            this.compositions.add(ele);
        }
        return this;
    }

    public ListCompositionsResult withCompositions(Collection<CompositionSummary> compositions) {
        this.setCompositions(compositions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCompositionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCompositions() != null) {
            sb.append("Compositions: ").append(this.getCompositions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCompositionsResult)) {
            return false;
        }
        ListCompositionsResult other = (ListCompositionsResult)obj;
        if (other.getCompositions() == null ^ this.getCompositions() == null) {
            return false;
        }
        if (other.getCompositions() != null && !other.getCompositions().equals(this.getCompositions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCompositions() == null ? 0 : this.getCompositions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListCompositionsResult clone() {
        try {
            return (ListCompositionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

