/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivsrealtime;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ivsrealtime.AmazonIVSRealTime;
import com.amazonaws.services.ivsrealtime.AmazonIVSRealTimeClientBuilder;
import com.amazonaws.services.ivsrealtime.model.AmazonIVSRealTimeException;
import com.amazonaws.services.ivsrealtime.model.CreateEncoderConfigurationRequest;
import com.amazonaws.services.ivsrealtime.model.CreateEncoderConfigurationResult;
import com.amazonaws.services.ivsrealtime.model.CreateParticipantTokenRequest;
import com.amazonaws.services.ivsrealtime.model.CreateParticipantTokenResult;
import com.amazonaws.services.ivsrealtime.model.CreateStageRequest;
import com.amazonaws.services.ivsrealtime.model.CreateStageResult;
import com.amazonaws.services.ivsrealtime.model.CreateStorageConfigurationRequest;
import com.amazonaws.services.ivsrealtime.model.CreateStorageConfigurationResult;
import com.amazonaws.services.ivsrealtime.model.DeleteEncoderConfigurationRequest;
import com.amazonaws.services.ivsrealtime.model.DeleteEncoderConfigurationResult;
import com.amazonaws.services.ivsrealtime.model.DeleteStageRequest;
import com.amazonaws.services.ivsrealtime.model.DeleteStageResult;
import com.amazonaws.services.ivsrealtime.model.DeleteStorageConfigurationRequest;
import com.amazonaws.services.ivsrealtime.model.DeleteStorageConfigurationResult;
import com.amazonaws.services.ivsrealtime.model.DisconnectParticipantRequest;
import com.amazonaws.services.ivsrealtime.model.DisconnectParticipantResult;
import com.amazonaws.services.ivsrealtime.model.GetCompositionRequest;
import com.amazonaws.services.ivsrealtime.model.GetCompositionResult;
import com.amazonaws.services.ivsrealtime.model.GetEncoderConfigurationRequest;
import com.amazonaws.services.ivsrealtime.model.GetEncoderConfigurationResult;
import com.amazonaws.services.ivsrealtime.model.GetParticipantRequest;
import com.amazonaws.services.ivsrealtime.model.GetParticipantResult;
import com.amazonaws.services.ivsrealtime.model.GetStageRequest;
import com.amazonaws.services.ivsrealtime.model.GetStageResult;
import com.amazonaws.services.ivsrealtime.model.GetStageSessionRequest;
import com.amazonaws.services.ivsrealtime.model.GetStageSessionResult;
import com.amazonaws.services.ivsrealtime.model.GetStorageConfigurationRequest;
import com.amazonaws.services.ivsrealtime.model.GetStorageConfigurationResult;
import com.amazonaws.services.ivsrealtime.model.ListCompositionsRequest;
import com.amazonaws.services.ivsrealtime.model.ListCompositionsResult;
import com.amazonaws.services.ivsrealtime.model.ListEncoderConfigurationsRequest;
import com.amazonaws.services.ivsrealtime.model.ListEncoderConfigurationsResult;
import com.amazonaws.services.ivsrealtime.model.ListParticipantEventsRequest;
import com.amazonaws.services.ivsrealtime.model.ListParticipantEventsResult;
import com.amazonaws.services.ivsrealtime.model.ListParticipantsRequest;
import com.amazonaws.services.ivsrealtime.model.ListParticipantsResult;
import com.amazonaws.services.ivsrealtime.model.ListStageSessionsRequest;
import com.amazonaws.services.ivsrealtime.model.ListStageSessionsResult;
import com.amazonaws.services.ivsrealtime.model.ListStagesRequest;
import com.amazonaws.services.ivsrealtime.model.ListStagesResult;
import com.amazonaws.services.ivsrealtime.model.ListStorageConfigurationsRequest;
import com.amazonaws.services.ivsrealtime.model.ListStorageConfigurationsResult;
import com.amazonaws.services.ivsrealtime.model.ListTagsForResourceRequest;
import com.amazonaws.services.ivsrealtime.model.ListTagsForResourceResult;
import com.amazonaws.services.ivsrealtime.model.StartCompositionRequest;
import com.amazonaws.services.ivsrealtime.model.StartCompositionResult;
import com.amazonaws.services.ivsrealtime.model.StopCompositionRequest;
import com.amazonaws.services.ivsrealtime.model.StopCompositionResult;
import com.amazonaws.services.ivsrealtime.model.TagResourceRequest;
import com.amazonaws.services.ivsrealtime.model.TagResourceResult;
import com.amazonaws.services.ivsrealtime.model.UntagResourceRequest;
import com.amazonaws.services.ivsrealtime.model.UntagResourceResult;
import com.amazonaws.services.ivsrealtime.model.UpdateStageRequest;
import com.amazonaws.services.ivsrealtime.model.UpdateStageResult;
import com.amazonaws.services.ivsrealtime.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.CreateEncoderConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.CreateEncoderConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.CreateParticipantTokenRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.CreateParticipantTokenResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.CreateStageRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.CreateStageResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.CreateStorageConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.CreateStorageConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.DeleteEncoderConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.DeleteEncoderConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.DeleteStageRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.DeleteStageResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.DeleteStorageConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.DeleteStorageConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.DisconnectParticipantRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.DisconnectParticipantResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.GetCompositionRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.GetCompositionResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.GetEncoderConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.GetEncoderConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.GetParticipantRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.GetParticipantResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.GetStageRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.GetStageResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.GetStageSessionRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.GetStageSessionResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.GetStorageConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.GetStorageConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListCompositionsRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListCompositionsResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListEncoderConfigurationsRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListEncoderConfigurationsResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListParticipantEventsRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListParticipantEventsResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListParticipantsRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListParticipantsResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListStageSessionsRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListStageSessionsResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListStagesRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListStagesResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListStorageConfigurationsRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListStorageConfigurationsResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.PendingVerificationExceptionUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.StartCompositionRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.StartCompositionResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.StopCompositionRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.StopCompositionResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.UpdateStageRequestProtocolMarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.UpdateStageResultJsonUnmarshaller;
import com.amazonaws.services.ivsrealtime.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonIVSRealTimeClient
extends AmazonWebServiceClient
implements AmazonIVSRealTime {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonIVSRealTime.class);
    private static final String DEFAULT_SIGNING_NAME = "ivs";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PendingVerification").withExceptionUnmarshaller((JsonErrorUnmarshaller)PendingVerificationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonIVSRealTimeException.class));

    public static AmazonIVSRealTimeClientBuilder builder() {
        return AmazonIVSRealTimeClientBuilder.standard();
    }

    AmazonIVSRealTimeClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonIVSRealTimeClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("ivsrealtime");
        this.setEndpoint("ivsrealtime.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ivsrealtime/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ivsrealtime/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateEncoderConfigurationResult createEncoderConfiguration(CreateEncoderConfigurationRequest request) {
        request = (CreateEncoderConfigurationRequest)this.beforeClientExecution(request);
        return this.executeCreateEncoderConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateEncoderConfigurationResult executeCreateEncoderConfiguration(CreateEncoderConfigurationRequest createEncoderConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createEncoderConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateEncoderConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateEncoderConfigurationRequestProtocolMarshaller(protocolFactory).marshall((CreateEncoderConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createEncoderConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateEncoderConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEncoderConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateEncoderConfigurationResult createEncoderConfigurationResult = (CreateEncoderConfigurationResult)response.getAwsResponse();
            return createEncoderConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateParticipantTokenResult createParticipantToken(CreateParticipantTokenRequest request) {
        request = (CreateParticipantTokenRequest)this.beforeClientExecution(request);
        return this.executeCreateParticipantToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateParticipantTokenResult executeCreateParticipantToken(CreateParticipantTokenRequest createParticipantTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createParticipantTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateParticipantTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateParticipantTokenRequestProtocolMarshaller(protocolFactory).marshall((CreateParticipantTokenRequest)super.beforeMarshalling((AmazonWebServiceRequest)createParticipantTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateParticipantToken");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateParticipantTokenResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateParticipantTokenResult createParticipantTokenResult = (CreateParticipantTokenResult)response.getAwsResponse();
            return createParticipantTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateStageResult createStage(CreateStageRequest request) {
        request = (CreateStageRequest)this.beforeClientExecution(request);
        return this.executeCreateStage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateStageResult executeCreateStage(CreateStageRequest createStageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createStageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateStageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateStageRequestProtocolMarshaller(protocolFactory).marshall((CreateStageRequest)super.beforeMarshalling((AmazonWebServiceRequest)createStageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateStage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateStageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateStageResult createStageResult = (CreateStageResult)response.getAwsResponse();
            return createStageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateStorageConfigurationResult createStorageConfiguration(CreateStorageConfigurationRequest request) {
        request = (CreateStorageConfigurationRequest)this.beforeClientExecution(request);
        return this.executeCreateStorageConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateStorageConfigurationResult executeCreateStorageConfiguration(CreateStorageConfigurationRequest createStorageConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createStorageConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateStorageConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateStorageConfigurationRequestProtocolMarshaller(protocolFactory).marshall((CreateStorageConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createStorageConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateStorageConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateStorageConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateStorageConfigurationResult createStorageConfigurationResult = (CreateStorageConfigurationResult)response.getAwsResponse();
            return createStorageConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteEncoderConfigurationResult deleteEncoderConfiguration(DeleteEncoderConfigurationRequest request) {
        request = (DeleteEncoderConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeleteEncoderConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteEncoderConfigurationResult executeDeleteEncoderConfiguration(DeleteEncoderConfigurationRequest deleteEncoderConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEncoderConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEncoderConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEncoderConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DeleteEncoderConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteEncoderConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteEncoderConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEncoderConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteEncoderConfigurationResult deleteEncoderConfigurationResult = (DeleteEncoderConfigurationResult)response.getAwsResponse();
            return deleteEncoderConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteStageResult deleteStage(DeleteStageRequest request) {
        request = (DeleteStageRequest)this.beforeClientExecution(request);
        return this.executeDeleteStage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteStageResult executeDeleteStage(DeleteStageRequest deleteStageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteStageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteStageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteStageRequestProtocolMarshaller(protocolFactory).marshall((DeleteStageRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteStageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteStage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteStageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteStageResult deleteStageResult = (DeleteStageResult)response.getAwsResponse();
            return deleteStageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteStorageConfigurationResult deleteStorageConfiguration(DeleteStorageConfigurationRequest request) {
        request = (DeleteStorageConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeleteStorageConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteStorageConfigurationResult executeDeleteStorageConfiguration(DeleteStorageConfigurationRequest deleteStorageConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteStorageConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteStorageConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteStorageConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DeleteStorageConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteStorageConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteStorageConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteStorageConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteStorageConfigurationResult deleteStorageConfigurationResult = (DeleteStorageConfigurationResult)response.getAwsResponse();
            return deleteStorageConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisconnectParticipantResult disconnectParticipant(DisconnectParticipantRequest request) {
        request = (DisconnectParticipantRequest)this.beforeClientExecution(request);
        return this.executeDisconnectParticipant(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisconnectParticipantResult executeDisconnectParticipant(DisconnectParticipantRequest disconnectParticipantRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disconnectParticipantRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisconnectParticipantRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisconnectParticipantRequestProtocolMarshaller(protocolFactory).marshall((DisconnectParticipantRequest)super.beforeMarshalling((AmazonWebServiceRequest)disconnectParticipantRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisconnectParticipant");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisconnectParticipantResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisconnectParticipantResult disconnectParticipantResult = (DisconnectParticipantResult)response.getAwsResponse();
            return disconnectParticipantResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCompositionResult getComposition(GetCompositionRequest request) {
        request = (GetCompositionRequest)this.beforeClientExecution(request);
        return this.executeGetComposition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCompositionResult executeGetComposition(GetCompositionRequest getCompositionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCompositionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCompositionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCompositionRequestProtocolMarshaller(protocolFactory).marshall((GetCompositionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCompositionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetComposition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCompositionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCompositionResult getCompositionResult = (GetCompositionResult)response.getAwsResponse();
            return getCompositionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEncoderConfigurationResult getEncoderConfiguration(GetEncoderConfigurationRequest request) {
        request = (GetEncoderConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetEncoderConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEncoderConfigurationResult executeGetEncoderConfiguration(GetEncoderConfigurationRequest getEncoderConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEncoderConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEncoderConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEncoderConfigurationRequestProtocolMarshaller(protocolFactory).marshall((GetEncoderConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEncoderConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEncoderConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEncoderConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEncoderConfigurationResult getEncoderConfigurationResult = (GetEncoderConfigurationResult)response.getAwsResponse();
            return getEncoderConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetParticipantResult getParticipant(GetParticipantRequest request) {
        request = (GetParticipantRequest)this.beforeClientExecution(request);
        return this.executeGetParticipant(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetParticipantResult executeGetParticipant(GetParticipantRequest getParticipantRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getParticipantRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetParticipantRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetParticipantRequestProtocolMarshaller(protocolFactory).marshall((GetParticipantRequest)super.beforeMarshalling((AmazonWebServiceRequest)getParticipantRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetParticipant");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetParticipantResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetParticipantResult getParticipantResult = (GetParticipantResult)response.getAwsResponse();
            return getParticipantResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetStageResult getStage(GetStageRequest request) {
        request = (GetStageRequest)this.beforeClientExecution(request);
        return this.executeGetStage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetStageResult executeGetStage(GetStageRequest getStageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getStageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetStageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetStageRequestProtocolMarshaller(protocolFactory).marshall((GetStageRequest)super.beforeMarshalling((AmazonWebServiceRequest)getStageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetStage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetStageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetStageResult getStageResult = (GetStageResult)response.getAwsResponse();
            return getStageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetStageSessionResult getStageSession(GetStageSessionRequest request) {
        request = (GetStageSessionRequest)this.beforeClientExecution(request);
        return this.executeGetStageSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetStageSessionResult executeGetStageSession(GetStageSessionRequest getStageSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getStageSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetStageSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetStageSessionRequestProtocolMarshaller(protocolFactory).marshall((GetStageSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getStageSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetStageSession");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetStageSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetStageSessionResult getStageSessionResult = (GetStageSessionResult)response.getAwsResponse();
            return getStageSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetStorageConfigurationResult getStorageConfiguration(GetStorageConfigurationRequest request) {
        request = (GetStorageConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetStorageConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetStorageConfigurationResult executeGetStorageConfiguration(GetStorageConfigurationRequest getStorageConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getStorageConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetStorageConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetStorageConfigurationRequestProtocolMarshaller(protocolFactory).marshall((GetStorageConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getStorageConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetStorageConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetStorageConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetStorageConfigurationResult getStorageConfigurationResult = (GetStorageConfigurationResult)response.getAwsResponse();
            return getStorageConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCompositionsResult listCompositions(ListCompositionsRequest request) {
        request = (ListCompositionsRequest)this.beforeClientExecution(request);
        return this.executeListCompositions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCompositionsResult executeListCompositions(ListCompositionsRequest listCompositionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCompositionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCompositionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCompositionsRequestProtocolMarshaller(protocolFactory).marshall((ListCompositionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCompositionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListCompositions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCompositionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCompositionsResult listCompositionsResult = (ListCompositionsResult)response.getAwsResponse();
            return listCompositionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEncoderConfigurationsResult listEncoderConfigurations(ListEncoderConfigurationsRequest request) {
        request = (ListEncoderConfigurationsRequest)this.beforeClientExecution(request);
        return this.executeListEncoderConfigurations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEncoderConfigurationsResult executeListEncoderConfigurations(ListEncoderConfigurationsRequest listEncoderConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEncoderConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEncoderConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEncoderConfigurationsRequestProtocolMarshaller(protocolFactory).marshall((ListEncoderConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEncoderConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEncoderConfigurations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEncoderConfigurationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEncoderConfigurationsResult listEncoderConfigurationsResult = (ListEncoderConfigurationsResult)response.getAwsResponse();
            return listEncoderConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListParticipantEventsResult listParticipantEvents(ListParticipantEventsRequest request) {
        request = (ListParticipantEventsRequest)this.beforeClientExecution(request);
        return this.executeListParticipantEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListParticipantEventsResult executeListParticipantEvents(ListParticipantEventsRequest listParticipantEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listParticipantEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListParticipantEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListParticipantEventsRequestProtocolMarshaller(protocolFactory).marshall((ListParticipantEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listParticipantEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListParticipantEvents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListParticipantEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListParticipantEventsResult listParticipantEventsResult = (ListParticipantEventsResult)response.getAwsResponse();
            return listParticipantEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListParticipantsResult listParticipants(ListParticipantsRequest request) {
        request = (ListParticipantsRequest)this.beforeClientExecution(request);
        return this.executeListParticipants(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListParticipantsResult executeListParticipants(ListParticipantsRequest listParticipantsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listParticipantsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListParticipantsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListParticipantsRequestProtocolMarshaller(protocolFactory).marshall((ListParticipantsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listParticipantsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListParticipants");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListParticipantsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListParticipantsResult listParticipantsResult = (ListParticipantsResult)response.getAwsResponse();
            return listParticipantsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListStageSessionsResult listStageSessions(ListStageSessionsRequest request) {
        request = (ListStageSessionsRequest)this.beforeClientExecution(request);
        return this.executeListStageSessions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListStageSessionsResult executeListStageSessions(ListStageSessionsRequest listStageSessionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStageSessionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStageSessionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStageSessionsRequestProtocolMarshaller(protocolFactory).marshall((ListStageSessionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listStageSessionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListStageSessions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStageSessionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListStageSessionsResult listStageSessionsResult = (ListStageSessionsResult)response.getAwsResponse();
            return listStageSessionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListStagesResult listStages(ListStagesRequest request) {
        request = (ListStagesRequest)this.beforeClientExecution(request);
        return this.executeListStages(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListStagesResult executeListStages(ListStagesRequest listStagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStagesRequestProtocolMarshaller(protocolFactory).marshall((ListStagesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listStagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListStages");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStagesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListStagesResult listStagesResult = (ListStagesResult)response.getAwsResponse();
            return listStagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListStorageConfigurationsResult listStorageConfigurations(ListStorageConfigurationsRequest request) {
        request = (ListStorageConfigurationsRequest)this.beforeClientExecution(request);
        return this.executeListStorageConfigurations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListStorageConfigurationsResult executeListStorageConfigurations(ListStorageConfigurationsRequest listStorageConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStorageConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStorageConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStorageConfigurationsRequestProtocolMarshaller(protocolFactory).marshall((ListStorageConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listStorageConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListStorageConfigurations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStorageConfigurationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListStorageConfigurationsResult listStorageConfigurationsResult = (ListStorageConfigurationsResult)response.getAwsResponse();
            return listStorageConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartCompositionResult startComposition(StartCompositionRequest request) {
        request = (StartCompositionRequest)this.beforeClientExecution(request);
        return this.executeStartComposition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartCompositionResult executeStartComposition(StartCompositionRequest startCompositionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startCompositionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartCompositionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartCompositionRequestProtocolMarshaller(protocolFactory).marshall((StartCompositionRequest)super.beforeMarshalling((AmazonWebServiceRequest)startCompositionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartComposition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartCompositionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartCompositionResult startCompositionResult = (StartCompositionResult)response.getAwsResponse();
            return startCompositionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopCompositionResult stopComposition(StopCompositionRequest request) {
        request = (StopCompositionRequest)this.beforeClientExecution(request);
        return this.executeStopComposition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopCompositionResult executeStopComposition(StopCompositionRequest stopCompositionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopCompositionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopCompositionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopCompositionRequestProtocolMarshaller(protocolFactory).marshall((StopCompositionRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopCompositionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopComposition");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopCompositionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopCompositionResult stopCompositionResult = (StopCompositionResult)response.getAwsResponse();
            return stopCompositionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateStageResult updateStage(UpdateStageRequest request) {
        request = (UpdateStageRequest)this.beforeClientExecution(request);
        return this.executeUpdateStage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateStageResult executeUpdateStage(UpdateStageRequest updateStageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateStageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateStageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateStageRequestProtocolMarshaller(protocolFactory).marshall((UpdateStageRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateStageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IVS RealTime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateStage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateStageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateStageResult updateStageResult = (UpdateStageResult)response.getAwsResponse();
            return updateStageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

