/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivsrealtime.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ivsrealtime.model.DestinationConfiguration;
import com.amazonaws.services.ivsrealtime.model.LayoutConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StartCompositionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<DestinationConfiguration> destinations;
    private String idempotencyToken;
    private LayoutConfiguration layout;
    private String stageArn;
    private Map<String, String> tags;

    public List<DestinationConfiguration> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<DestinationConfiguration> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<DestinationConfiguration>(destinations);
    }

    public StartCompositionRequest withDestinations(DestinationConfiguration ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<DestinationConfiguration>(destinations.length));
        }
        for (DestinationConfiguration ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public StartCompositionRequest withDestinations(Collection<DestinationConfiguration> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public void setIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    public StartCompositionRequest withIdempotencyToken(String idempotencyToken) {
        this.setIdempotencyToken(idempotencyToken);
        return this;
    }

    public void setLayout(LayoutConfiguration layout) {
        this.layout = layout;
    }

    public LayoutConfiguration getLayout() {
        return this.layout;
    }

    public StartCompositionRequest withLayout(LayoutConfiguration layout) {
        this.setLayout(layout);
        return this;
    }

    public void setStageArn(String stageArn) {
        this.stageArn = stageArn;
    }

    public String getStageArn() {
        return this.stageArn;
    }

    public StartCompositionRequest withStageArn(String stageArn) {
        this.setStageArn(stageArn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public StartCompositionRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public StartCompositionRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public StartCompositionRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getIdempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.getIdempotencyToken()).append(",");
        }
        if (this.getLayout() != null) {
            sb.append("Layout: ").append(this.getLayout()).append(",");
        }
        if (this.getStageArn() != null) {
            sb.append("StageArn: ").append(this.getStageArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCompositionRequest)) {
            return false;
        }
        StartCompositionRequest other = (StartCompositionRequest)obj;
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getIdempotencyToken() == null ^ this.getIdempotencyToken() == null) {
            return false;
        }
        if (other.getIdempotencyToken() != null && !other.getIdempotencyToken().equals(this.getIdempotencyToken())) {
            return false;
        }
        if (other.getLayout() == null ^ this.getLayout() == null) {
            return false;
        }
        if (other.getLayout() != null && !other.getLayout().equals(this.getLayout())) {
            return false;
        }
        if (other.getStageArn() == null ^ this.getStageArn() == null) {
            return false;
        }
        if (other.getStageArn() != null && !other.getStageArn().equals(this.getStageArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getIdempotencyToken() == null ? 0 : this.getIdempotencyToken().hashCode());
        hashCode = 31 * hashCode + (this.getLayout() == null ? 0 : this.getLayout().hashCode());
        hashCode = 31 * hashCode + (this.getStageArn() == null ? 0 : this.getStageArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public StartCompositionRequest clone() {
        return (StartCompositionRequest)super.clone();
    }
}

