/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivsrealtime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ivsrealtime.model.ParticipantState;
import com.amazonaws.services.ivsrealtime.model.transform.ParticipantMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Participant
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> attributes;
    private String browserName;
    private String browserVersion;
    private Date firstJoinTime;
    private String ispName;
    private String osName;
    private String osVersion;
    private String participantId;
    private Boolean published;
    private String sdkVersion;
    private String state;
    private String userId;

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Participant withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public Participant addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public Participant clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public Participant withBrowserName(String browserName) {
        this.setBrowserName(browserName);
        return this;
    }

    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public Participant withBrowserVersion(String browserVersion) {
        this.setBrowserVersion(browserVersion);
        return this;
    }

    public void setFirstJoinTime(Date firstJoinTime) {
        this.firstJoinTime = firstJoinTime;
    }

    public Date getFirstJoinTime() {
        return this.firstJoinTime;
    }

    public Participant withFirstJoinTime(Date firstJoinTime) {
        this.setFirstJoinTime(firstJoinTime);
        return this;
    }

    public void setIspName(String ispName) {
        this.ispName = ispName;
    }

    public String getIspName() {
        return this.ispName;
    }

    public Participant withIspName(String ispName) {
        this.setIspName(ispName);
        return this;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsName() {
        return this.osName;
    }

    public Participant withOsName(String osName) {
        this.setOsName(osName);
        return this;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public Participant withOsVersion(String osVersion) {
        this.setOsVersion(osVersion);
        return this;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public Participant withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public void setPublished(Boolean published) {
        this.published = published;
    }

    public Boolean getPublished() {
        return this.published;
    }

    public Participant withPublished(Boolean published) {
        this.setPublished(published);
        return this;
    }

    public Boolean isPublished() {
        return this.published;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public Participant withSdkVersion(String sdkVersion) {
        this.setSdkVersion(sdkVersion);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Participant withState(String state) {
        this.setState(state);
        return this;
    }

    public Participant withState(ParticipantState state) {
        this.state = state.toString();
        return this;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Participant withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getBrowserName() != null) {
            sb.append("BrowserName: ").append(this.getBrowserName()).append(",");
        }
        if (this.getBrowserVersion() != null) {
            sb.append("BrowserVersion: ").append(this.getBrowserVersion()).append(",");
        }
        if (this.getFirstJoinTime() != null) {
            sb.append("FirstJoinTime: ").append(this.getFirstJoinTime()).append(",");
        }
        if (this.getIspName() != null) {
            sb.append("IspName: ").append(this.getIspName()).append(",");
        }
        if (this.getOsName() != null) {
            sb.append("OsName: ").append(this.getOsName()).append(",");
        }
        if (this.getOsVersion() != null) {
            sb.append("OsVersion: ").append(this.getOsVersion()).append(",");
        }
        if (this.getParticipantId() != null) {
            sb.append("ParticipantId: ").append(this.getParticipantId()).append(",");
        }
        if (this.getPublished() != null) {
            sb.append("Published: ").append(this.getPublished()).append(",");
        }
        if (this.getSdkVersion() != null) {
            sb.append("SdkVersion: ").append(this.getSdkVersion()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getUserId() != null) {
            sb.append("UserId: ").append(this.getUserId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Participant)) {
            return false;
        }
        Participant other = (Participant)obj;
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getBrowserName() == null ^ this.getBrowserName() == null) {
            return false;
        }
        if (other.getBrowserName() != null && !other.getBrowserName().equals(this.getBrowserName())) {
            return false;
        }
        if (other.getBrowserVersion() == null ^ this.getBrowserVersion() == null) {
            return false;
        }
        if (other.getBrowserVersion() != null && !other.getBrowserVersion().equals(this.getBrowserVersion())) {
            return false;
        }
        if (other.getFirstJoinTime() == null ^ this.getFirstJoinTime() == null) {
            return false;
        }
        if (other.getFirstJoinTime() != null && !other.getFirstJoinTime().equals(this.getFirstJoinTime())) {
            return false;
        }
        if (other.getIspName() == null ^ this.getIspName() == null) {
            return false;
        }
        if (other.getIspName() != null && !other.getIspName().equals(this.getIspName())) {
            return false;
        }
        if (other.getOsName() == null ^ this.getOsName() == null) {
            return false;
        }
        if (other.getOsName() != null && !other.getOsName().equals(this.getOsName())) {
            return false;
        }
        if (other.getOsVersion() == null ^ this.getOsVersion() == null) {
            return false;
        }
        if (other.getOsVersion() != null && !other.getOsVersion().equals(this.getOsVersion())) {
            return false;
        }
        if (other.getParticipantId() == null ^ this.getParticipantId() == null) {
            return false;
        }
        if (other.getParticipantId() != null && !other.getParticipantId().equals(this.getParticipantId())) {
            return false;
        }
        if (other.getPublished() == null ^ this.getPublished() == null) {
            return false;
        }
        if (other.getPublished() != null && !other.getPublished().equals(this.getPublished())) {
            return false;
        }
        if (other.getSdkVersion() == null ^ this.getSdkVersion() == null) {
            return false;
        }
        if (other.getSdkVersion() != null && !other.getSdkVersion().equals(this.getSdkVersion())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getUserId() == null ^ this.getUserId() == null) {
            return false;
        }
        return other.getUserId() == null || other.getUserId().equals(this.getUserId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getBrowserName() == null ? 0 : this.getBrowserName().hashCode());
        hashCode = 31 * hashCode + (this.getBrowserVersion() == null ? 0 : this.getBrowserVersion().hashCode());
        hashCode = 31 * hashCode + (this.getFirstJoinTime() == null ? 0 : this.getFirstJoinTime().hashCode());
        hashCode = 31 * hashCode + (this.getIspName() == null ? 0 : this.getIspName().hashCode());
        hashCode = 31 * hashCode + (this.getOsName() == null ? 0 : this.getOsName().hashCode());
        hashCode = 31 * hashCode + (this.getOsVersion() == null ? 0 : this.getOsVersion().hashCode());
        hashCode = 31 * hashCode + (this.getParticipantId() == null ? 0 : this.getParticipantId().hashCode());
        hashCode = 31 * hashCode + (this.getPublished() == null ? 0 : this.getPublished().hashCode());
        hashCode = 31 * hashCode + (this.getSdkVersion() == null ? 0 : this.getSdkVersion().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        return hashCode;
    }

    public Participant clone() {
        try {
            return (Participant)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParticipantMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

