/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ivsrealtime.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStageSessions" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListStageSessionsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * If there are more stage sessions than <code>maxResults</code>, use <code>nextToken</code> in the request to get
     * the next set.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * List of matching stage sessions.
     * </p>
     */
    private java.util.List<StageSessionSummary> stageSessions;

    /**
     * <p>
     * If there are more stage sessions than <code>maxResults</code>, use <code>nextToken</code> in the request to get
     * the next set.
     * </p>
     * 
     * @param nextToken
     *        If there are more stage sessions than <code>maxResults</code>, use <code>nextToken</code> in the request
     *        to get the next set.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If there are more stage sessions than <code>maxResults</code>, use <code>nextToken</code> in the request to get
     * the next set.
     * </p>
     * 
     * @return If there are more stage sessions than <code>maxResults</code>, use <code>nextToken</code> in the request
     *         to get the next set.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If there are more stage sessions than <code>maxResults</code>, use <code>nextToken</code> in the request to get
     * the next set.
     * </p>
     * 
     * @param nextToken
     *        If there are more stage sessions than <code>maxResults</code>, use <code>nextToken</code> in the request
     *        to get the next set.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListStageSessionsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * List of matching stage sessions.
     * </p>
     * 
     * @return List of matching stage sessions.
     */

    public java.util.List<StageSessionSummary> getStageSessions() {
        return stageSessions;
    }

    /**
     * <p>
     * List of matching stage sessions.
     * </p>
     * 
     * @param stageSessions
     *        List of matching stage sessions.
     */

    public void setStageSessions(java.util.Collection<StageSessionSummary> stageSessions) {
        if (stageSessions == null) {
            this.stageSessions = null;
            return;
        }

        this.stageSessions = new java.util.ArrayList<StageSessionSummary>(stageSessions);
    }

    /**
     * <p>
     * List of matching stage sessions.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setStageSessions(java.util.Collection)} or {@link #withStageSessions(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param stageSessions
     *        List of matching stage sessions.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListStageSessionsResult withStageSessions(StageSessionSummary... stageSessions) {
        if (this.stageSessions == null) {
            setStageSessions(new java.util.ArrayList<StageSessionSummary>(stageSessions.length));
        }
        for (StageSessionSummary ele : stageSessions) {
            this.stageSessions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * List of matching stage sessions.
     * </p>
     * 
     * @param stageSessions
     *        List of matching stage sessions.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListStageSessionsResult withStageSessions(java.util.Collection<StageSessionSummary> stageSessions) {
        setStageSessions(stageSessions);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getStageSessions() != null)
            sb.append("StageSessions: ").append(getStageSessions());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListStageSessionsResult == false)
            return false;
        ListStageSessionsResult other = (ListStageSessionsResult) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getStageSessions() == null ^ this.getStageSessions() == null)
            return false;
        if (other.getStageSessions() != null && other.getStageSessions().equals(this.getStageSessions()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getStageSessions() == null) ? 0 : getStageSessions().hashCode());
        return hashCode;
    }

    @Override
    public ListStageSessionsResult clone() {
        try {
            return (ListStageSessionsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
