/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivschat.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.ivschat.model.RoomSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRoomsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<RoomSummary> rooms;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRoomsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<RoomSummary> getRooms() {
        return this.rooms;
    }

    public void setRooms(Collection<RoomSummary> rooms) {
        if (rooms == null) {
            this.rooms = null;
            return;
        }
        this.rooms = new ArrayList<RoomSummary>(rooms);
    }

    public ListRoomsResult withRooms(RoomSummary ... rooms) {
        if (this.rooms == null) {
            this.setRooms(new ArrayList<RoomSummary>(rooms.length));
        }
        for (RoomSummary ele : rooms) {
            this.rooms.add(ele);
        }
        return this;
    }

    public ListRoomsResult withRooms(Collection<RoomSummary> rooms) {
        this.setRooms(rooms);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRooms() != null) {
            sb.append("Rooms: ").append(this.getRooms());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoomsResult)) {
            return false;
        }
        ListRoomsResult other = (ListRoomsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRooms() == null ^ this.getRooms() == null) {
            return false;
        }
        return other.getRooms() == null || other.getRooms().equals(this.getRooms());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRooms() == null ? 0 : this.getRooms().hashCode());
        return hashCode;
    }

    public ListRoomsResult clone() {
        try {
            return (ListRoomsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

