/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotwireless.model.PositionResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdatePositionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceIdentifier;
    private String resourceType;
    private List<Float> position;

    public void setResourceIdentifier(String resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public UpdatePositionRequest withResourceIdentifier(String resourceIdentifier) {
        this.setResourceIdentifier(resourceIdentifier);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public UpdatePositionRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public UpdatePositionRequest withResourceType(PositionResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<Float> getPosition() {
        return this.position;
    }

    public void setPosition(Collection<Float> position) {
        if (position == null) {
            this.position = null;
            return;
        }
        this.position = new ArrayList<Float>(position);
    }

    public UpdatePositionRequest withPosition(Float ... position) {
        if (this.position == null) {
            this.setPosition(new ArrayList<Float>(position.length));
        }
        for (Float ele : position) {
            this.position.add(ele);
        }
        return this;
    }

    public UpdatePositionRequest withPosition(Collection<Float> position) {
        this.setPosition(position);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceIdentifier() != null) {
            sb.append("ResourceIdentifier: ").append(this.getResourceIdentifier()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getPosition() != null) {
            sb.append("Position: ").append(this.getPosition());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePositionRequest)) {
            return false;
        }
        UpdatePositionRequest other = (UpdatePositionRequest)obj;
        if (other.getResourceIdentifier() == null ^ this.getResourceIdentifier() == null) {
            return false;
        }
        if (other.getResourceIdentifier() != null && !other.getResourceIdentifier().equals(this.getResourceIdentifier())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getPosition() == null ^ this.getPosition() == null) {
            return false;
        }
        return other.getPosition() == null || other.getPosition().equals(this.getPosition());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceIdentifier() == null ? 0 : this.getResourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
        return hashCode;
    }

    public UpdatePositionRequest clone() {
        return (UpdatePositionRequest)super.clone();
    }
}

