/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iotwireless.model.Accuracy;
import com.amazonaws.services.iotwireless.model.PositionSolverProvider;
import com.amazonaws.services.iotwireless.model.PositionSolverType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetPositionResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Float> position;
    private Accuracy accuracy;
    private String solverType;
    private String solverProvider;
    private String solverVersion;
    private String timestamp;

    public List<Float> getPosition() {
        return this.position;
    }

    public void setPosition(Collection<Float> position) {
        if (position == null) {
            this.position = null;
            return;
        }
        this.position = new ArrayList<Float>(position);
    }

    public GetPositionResult withPosition(Float ... position) {
        if (this.position == null) {
            this.setPosition(new ArrayList<Float>(position.length));
        }
        for (Float ele : position) {
            this.position.add(ele);
        }
        return this;
    }

    public GetPositionResult withPosition(Collection<Float> position) {
        this.setPosition(position);
        return this;
    }

    public void setAccuracy(Accuracy accuracy) {
        this.accuracy = accuracy;
    }

    public Accuracy getAccuracy() {
        return this.accuracy;
    }

    public GetPositionResult withAccuracy(Accuracy accuracy) {
        this.setAccuracy(accuracy);
        return this;
    }

    public void setSolverType(String solverType) {
        this.solverType = solverType;
    }

    public String getSolverType() {
        return this.solverType;
    }

    public GetPositionResult withSolverType(String solverType) {
        this.setSolverType(solverType);
        return this;
    }

    public GetPositionResult withSolverType(PositionSolverType solverType) {
        this.solverType = solverType.toString();
        return this;
    }

    public void setSolverProvider(String solverProvider) {
        this.solverProvider = solverProvider;
    }

    public String getSolverProvider() {
        return this.solverProvider;
    }

    public GetPositionResult withSolverProvider(String solverProvider) {
        this.setSolverProvider(solverProvider);
        return this;
    }

    public GetPositionResult withSolverProvider(PositionSolverProvider solverProvider) {
        this.solverProvider = solverProvider.toString();
        return this;
    }

    public void setSolverVersion(String solverVersion) {
        this.solverVersion = solverVersion;
    }

    public String getSolverVersion() {
        return this.solverVersion;
    }

    public GetPositionResult withSolverVersion(String solverVersion) {
        this.setSolverVersion(solverVersion);
        return this;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public GetPositionResult withTimestamp(String timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPosition() != null) {
            sb.append("Position: ").append(this.getPosition()).append(",");
        }
        if (this.getAccuracy() != null) {
            sb.append("Accuracy: ").append(this.getAccuracy()).append(",");
        }
        if (this.getSolverType() != null) {
            sb.append("SolverType: ").append(this.getSolverType()).append(",");
        }
        if (this.getSolverProvider() != null) {
            sb.append("SolverProvider: ").append(this.getSolverProvider()).append(",");
        }
        if (this.getSolverVersion() != null) {
            sb.append("SolverVersion: ").append(this.getSolverVersion()).append(",");
        }
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPositionResult)) {
            return false;
        }
        GetPositionResult other = (GetPositionResult)obj;
        if (other.getPosition() == null ^ this.getPosition() == null) {
            return false;
        }
        if (other.getPosition() != null && !other.getPosition().equals(this.getPosition())) {
            return false;
        }
        if (other.getAccuracy() == null ^ this.getAccuracy() == null) {
            return false;
        }
        if (other.getAccuracy() != null && !other.getAccuracy().equals(this.getAccuracy())) {
            return false;
        }
        if (other.getSolverType() == null ^ this.getSolverType() == null) {
            return false;
        }
        if (other.getSolverType() != null && !other.getSolverType().equals(this.getSolverType())) {
            return false;
        }
        if (other.getSolverProvider() == null ^ this.getSolverProvider() == null) {
            return false;
        }
        if (other.getSolverProvider() != null && !other.getSolverProvider().equals(this.getSolverProvider())) {
            return false;
        }
        if (other.getSolverVersion() == null ^ this.getSolverVersion() == null) {
            return false;
        }
        if (other.getSolverVersion() != null && !other.getSolverVersion().equals(this.getSolverVersion())) {
            return false;
        }
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        return other.getTimestamp() == null || other.getTimestamp().equals(this.getTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
        hashCode = 31 * hashCode + (this.getAccuracy() == null ? 0 : this.getAccuracy().hashCode());
        hashCode = 31 * hashCode + (this.getSolverType() == null ? 0 : this.getSolverType().hashCode());
        hashCode = 31 * hashCode + (this.getSolverProvider() == null ? 0 : this.getSolverProvider().hashCode());
        hashCode = 31 * hashCode + (this.getSolverVersion() == null ? 0 : this.getSolverVersion().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        return hashCode;
    }

    public GetPositionResult clone() {
        try {
            return (GetPositionResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

