/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.DataConnector;

@SdkInternalApi
public class DataConnectorMarshaller {
    private static final MarshallingInfo<Boolean> ISNATIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isNative").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambda").build();
    private static final DataConnectorMarshaller instance = new DataConnectorMarshaller();

    public static DataConnectorMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataConnector dataConnector, ProtocolMarshaller protocolMarshaller) {
        if (dataConnector == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataConnector.getIsNative(), ISNATIVE_BINDING);
            protocolMarshaller.marshall((Object)dataConnector.getLambda(), LAMBDA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

