/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotthingsgraph.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotthingsgraph.model.DefinitionDocument;
import com.amazonaws.services.iotthingsgraph.model.DeploymentTarget;
import com.amazonaws.services.iotthingsgraph.model.MetricsConfiguration;
import com.amazonaws.services.iotthingsgraph.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateSystemInstanceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<Tag> tags;
    private DefinitionDocument definition;
    private String target;
    private String greengrassGroupName;
    private String s3BucketName;
    private MetricsConfiguration metricsConfiguration;
    private String flowActionsRoleArn;

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateSystemInstanceRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateSystemInstanceRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setDefinition(DefinitionDocument definition) {
        this.definition = definition;
    }

    public DefinitionDocument getDefinition() {
        return this.definition;
    }

    public CreateSystemInstanceRequest withDefinition(DefinitionDocument definition) {
        this.setDefinition(definition);
        return this;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public CreateSystemInstanceRequest withTarget(String target) {
        this.setTarget(target);
        return this;
    }

    public CreateSystemInstanceRequest withTarget(DeploymentTarget target) {
        this.target = target.toString();
        return this;
    }

    public void setGreengrassGroupName(String greengrassGroupName) {
        this.greengrassGroupName = greengrassGroupName;
    }

    public String getGreengrassGroupName() {
        return this.greengrassGroupName;
    }

    public CreateSystemInstanceRequest withGreengrassGroupName(String greengrassGroupName) {
        this.setGreengrassGroupName(greengrassGroupName);
        return this;
    }

    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public CreateSystemInstanceRequest withS3BucketName(String s3BucketName) {
        this.setS3BucketName(s3BucketName);
        return this;
    }

    public void setMetricsConfiguration(MetricsConfiguration metricsConfiguration) {
        this.metricsConfiguration = metricsConfiguration;
    }

    public MetricsConfiguration getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    public CreateSystemInstanceRequest withMetricsConfiguration(MetricsConfiguration metricsConfiguration) {
        this.setMetricsConfiguration(metricsConfiguration);
        return this;
    }

    public void setFlowActionsRoleArn(String flowActionsRoleArn) {
        this.flowActionsRoleArn = flowActionsRoleArn;
    }

    public String getFlowActionsRoleArn() {
        return this.flowActionsRoleArn;
    }

    public CreateSystemInstanceRequest withFlowActionsRoleArn(String flowActionsRoleArn) {
        this.setFlowActionsRoleArn(flowActionsRoleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getDefinition() != null) {
            sb.append("Definition: ").append(this.getDefinition()).append(",");
        }
        if (this.getTarget() != null) {
            sb.append("Target: ").append(this.getTarget()).append(",");
        }
        if (this.getGreengrassGroupName() != null) {
            sb.append("GreengrassGroupName: ").append(this.getGreengrassGroupName()).append(",");
        }
        if (this.getS3BucketName() != null) {
            sb.append("S3BucketName: ").append(this.getS3BucketName()).append(",");
        }
        if (this.getMetricsConfiguration() != null) {
            sb.append("MetricsConfiguration: ").append(this.getMetricsConfiguration()).append(",");
        }
        if (this.getFlowActionsRoleArn() != null) {
            sb.append("FlowActionsRoleArn: ").append(this.getFlowActionsRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSystemInstanceRequest)) {
            return false;
        }
        CreateSystemInstanceRequest other = (CreateSystemInstanceRequest)obj;
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getDefinition() == null ^ this.getDefinition() == null) {
            return false;
        }
        if (other.getDefinition() != null && !other.getDefinition().equals(this.getDefinition())) {
            return false;
        }
        if (other.getTarget() == null ^ this.getTarget() == null) {
            return false;
        }
        if (other.getTarget() != null && !other.getTarget().equals(this.getTarget())) {
            return false;
        }
        if (other.getGreengrassGroupName() == null ^ this.getGreengrassGroupName() == null) {
            return false;
        }
        if (other.getGreengrassGroupName() != null && !other.getGreengrassGroupName().equals(this.getGreengrassGroupName())) {
            return false;
        }
        if (other.getS3BucketName() == null ^ this.getS3BucketName() == null) {
            return false;
        }
        if (other.getS3BucketName() != null && !other.getS3BucketName().equals(this.getS3BucketName())) {
            return false;
        }
        if (other.getMetricsConfiguration() == null ^ this.getMetricsConfiguration() == null) {
            return false;
        }
        if (other.getMetricsConfiguration() != null && !other.getMetricsConfiguration().equals(this.getMetricsConfiguration())) {
            return false;
        }
        if (other.getFlowActionsRoleArn() == null ^ this.getFlowActionsRoleArn() == null) {
            return false;
        }
        return other.getFlowActionsRoleArn() == null || other.getFlowActionsRoleArn().equals(this.getFlowActionsRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getDefinition() == null ? 0 : this.getDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getTarget() == null ? 0 : this.getTarget().hashCode());
        hashCode = 31 * hashCode + (this.getGreengrassGroupName() == null ? 0 : this.getGreengrassGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getS3BucketName() == null ? 0 : this.getS3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricsConfiguration() == null ? 0 : this.getMetricsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getFlowActionsRoleArn() == null ? 0 : this.getFlowActionsRoleArn().hashCode());
        return hashCode;
    }

    public CreateSystemInstanceRequest clone() {
        return (CreateSystemInstanceRequest)super.clone();
    }
}

