/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotsitewise.model.PropertyType;

@SdkInternalApi
public class PropertyTypeMarshaller {
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attribute").build();
    private static final MarshallingInfo<StructuredPojo> MEASUREMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("measurement").build();
    private static final MarshallingInfo<StructuredPojo> TRANSFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transform").build();
    private static final MarshallingInfo<StructuredPojo> METRIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metric").build();
    private static final PropertyTypeMarshaller instance = new PropertyTypeMarshaller();

    public static PropertyTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(PropertyType propertyType, ProtocolMarshaller protocolMarshaller) {
        if (propertyType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)propertyType.getAttribute(), ATTRIBUTE_BINDING);
            protocolMarshaller.marshall((Object)propertyType.getMeasurement(), MEASUREMENT_BINDING);
            protocolMarshaller.marshall((Object)propertyType.getTransform(), TRANSFORM_BINDING);
            protocolMarshaller.marshall((Object)propertyType.getMetric(), METRIC_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

