/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotsitewise.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.iotsitewise.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * PutStorageConfigurationResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutStorageConfigurationResultJsonUnmarshaller implements Unmarshaller<PutStorageConfigurationResult, JsonUnmarshallerContext> {

    public PutStorageConfigurationResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        PutStorageConfigurationResult putStorageConfigurationResult = new PutStorageConfigurationResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return putStorageConfigurationResult;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("storageType", targetDepth)) {
                    context.nextToken();
                    putStorageConfigurationResult.setStorageType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("multiLayerStorage", targetDepth)) {
                    context.nextToken();
                    putStorageConfigurationResult.setMultiLayerStorage(MultiLayerStorageJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("disassociatedDataStorage", targetDepth)) {
                    context.nextToken();
                    putStorageConfigurationResult.setDisassociatedDataStorage(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("retentionPeriod", targetDepth)) {
                    context.nextToken();
                    putStorageConfigurationResult.setRetentionPeriod(RetentionPeriodJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("configurationStatus", targetDepth)) {
                    context.nextToken();
                    putStorageConfigurationResult.setConfigurationStatus(ConfigurationStatusJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("warmTier", targetDepth)) {
                    context.nextToken();
                    putStorageConfigurationResult.setWarmTier(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("warmTierRetentionPeriod", targetDepth)) {
                    context.nextToken();
                    putStorageConfigurationResult.setWarmTierRetentionPeriod(WarmTierRetentionPeriodJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return putStorageConfigurationResult;
    }

    private static PutStorageConfigurationResultJsonUnmarshaller instance;

    public static PutStorageConfigurationResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new PutStorageConfigurationResultJsonUnmarshaller();
        return instance;
    }
}
