/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsitewise.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotsitewise.model.AssetProperty;
import com.amazonaws.services.iotsitewise.model.transform.AssetCompositeModelMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AssetCompositeModel
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private String type;
    private List<AssetProperty> properties;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public AssetCompositeModel withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public AssetCompositeModel withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public AssetCompositeModel withType(String type) {
        this.setType(type);
        return this;
    }

    public List<AssetProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<AssetProperty> properties) {
        if (properties == null) {
            this.properties = null;
            return;
        }
        this.properties = new ArrayList<AssetProperty>(properties);
    }

    public AssetCompositeModel withProperties(AssetProperty ... properties) {
        if (this.properties == null) {
            this.setProperties(new ArrayList<AssetProperty>(properties.length));
        }
        for (AssetProperty ele : properties) {
            this.properties.add(ele);
        }
        return this;
    }

    public AssetCompositeModel withProperties(Collection<AssetProperty> properties) {
        this.setProperties(properties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetCompositeModel)) {
            return false;
        }
        AssetCompositeModel other = (AssetCompositeModel)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        return other.getProperties() == null || other.getProperties().equals(this.getProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        return hashCode;
    }

    public AssetCompositeModel clone() {
        try {
            return (AssetCompositeModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssetCompositeModelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

