/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotroborunner;

import javax.annotation.Generated;

import com.amazonaws.services.iotroborunner.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSIoTRoboRunner}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIoTRoboRunner implements AWSIoTRoboRunner {

    protected AbstractAWSIoTRoboRunner() {
    }

    @Override
    public CreateDestinationResult createDestination(CreateDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSiteResult createSite(CreateSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkerResult createWorker(CreateWorkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkerFleetResult createWorkerFleet(CreateWorkerFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDestinationResult deleteDestination(DeleteDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSiteResult deleteSite(DeleteSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkerResult deleteWorker(DeleteWorkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkerFleetResult deleteWorkerFleet(DeleteWorkerFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDestinationResult getDestination(GetDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSiteResult getSite(GetSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkerResult getWorker(GetWorkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkerFleetResult getWorkerFleet(GetWorkerFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDestinationsResult listDestinations(ListDestinationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSitesResult listSites(ListSitesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkerFleetsResult listWorkerFleets(ListWorkerFleetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkersResult listWorkers(ListWorkersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDestinationResult updateDestination(UpdateDestinationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSiteResult updateSite(UpdateSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkerResult updateWorker(UpdateWorkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkerFleetResult updateWorkerFleet(UpdateWorkerFleetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
