/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotevents;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iotevents.AWSIoTEvents;
import com.amazonaws.services.iotevents.AWSIoTEventsClientBuilder;
import com.amazonaws.services.iotevents.model.AWSIoTEventsException;
import com.amazonaws.services.iotevents.model.CreateDetectorModelRequest;
import com.amazonaws.services.iotevents.model.CreateDetectorModelResult;
import com.amazonaws.services.iotevents.model.CreateInputRequest;
import com.amazonaws.services.iotevents.model.CreateInputResult;
import com.amazonaws.services.iotevents.model.DeleteDetectorModelRequest;
import com.amazonaws.services.iotevents.model.DeleteDetectorModelResult;
import com.amazonaws.services.iotevents.model.DeleteInputRequest;
import com.amazonaws.services.iotevents.model.DeleteInputResult;
import com.amazonaws.services.iotevents.model.DescribeDetectorModelRequest;
import com.amazonaws.services.iotevents.model.DescribeDetectorModelResult;
import com.amazonaws.services.iotevents.model.DescribeInputRequest;
import com.amazonaws.services.iotevents.model.DescribeInputResult;
import com.amazonaws.services.iotevents.model.DescribeLoggingOptionsRequest;
import com.amazonaws.services.iotevents.model.DescribeLoggingOptionsResult;
import com.amazonaws.services.iotevents.model.ListDetectorModelVersionsRequest;
import com.amazonaws.services.iotevents.model.ListDetectorModelVersionsResult;
import com.amazonaws.services.iotevents.model.ListDetectorModelsRequest;
import com.amazonaws.services.iotevents.model.ListDetectorModelsResult;
import com.amazonaws.services.iotevents.model.ListInputsRequest;
import com.amazonaws.services.iotevents.model.ListInputsResult;
import com.amazonaws.services.iotevents.model.ListTagsForResourceRequest;
import com.amazonaws.services.iotevents.model.ListTagsForResourceResult;
import com.amazonaws.services.iotevents.model.PutLoggingOptionsRequest;
import com.amazonaws.services.iotevents.model.PutLoggingOptionsResult;
import com.amazonaws.services.iotevents.model.TagResourceRequest;
import com.amazonaws.services.iotevents.model.TagResourceResult;
import com.amazonaws.services.iotevents.model.UntagResourceRequest;
import com.amazonaws.services.iotevents.model.UntagResourceResult;
import com.amazonaws.services.iotevents.model.UpdateDetectorModelRequest;
import com.amazonaws.services.iotevents.model.UpdateDetectorModelResult;
import com.amazonaws.services.iotevents.model.UpdateInputRequest;
import com.amazonaws.services.iotevents.model.UpdateInputResult;
import com.amazonaws.services.iotevents.model.transform.CreateDetectorModelRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.CreateDetectorModelResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.CreateInputRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.CreateInputResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.DeleteDetectorModelRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.DeleteDetectorModelResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.DeleteInputRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.DeleteInputResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.DescribeDetectorModelRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.DescribeDetectorModelResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.DescribeInputRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.DescribeInputResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.DescribeLoggingOptionsRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.DescribeLoggingOptionsResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.InternalFailureExceptionUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.ListDetectorModelVersionsRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.ListDetectorModelVersionsResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.ListDetectorModelsRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.ListDetectorModelsResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.ListInputsRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.ListInputsResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.PutLoggingOptionsRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.PutLoggingOptionsResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.ResourceAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.UnsupportedOperationExceptionUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.UpdateDetectorModelRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.UpdateDetectorModelResultJsonUnmarshaller;
import com.amazonaws.services.iotevents.model.transform.UpdateInputRequestProtocolMarshaller;
import com.amazonaws.services.iotevents.model.transform.UpdateInputResultJsonUnmarshaller;
import com.amazonaws.transform.JsonBaseExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSIoTEventsClient
extends AmazonWebServiceClient
implements AWSIoTEvents {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSIoTEvents.class);
    private static final String DEFAULT_SIGNING_NAME = "iotevents";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalFailureExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceInUseExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedOperationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedOperationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode(null).withExceptionUnmarshaller((JsonErrorUnmarshaller)new JsonBaseExceptionUnmarshaller(AWSIoTEventsException.class))));

    public static AWSIoTEventsClientBuilder builder() {
        return AWSIoTEventsClientBuilder.standard();
    }

    AWSIoTEventsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSIoTEventsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("iotevents.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/iotevents/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/iotevents/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateDetectorModelResult createDetectorModel(CreateDetectorModelRequest request) {
        request = (CreateDetectorModelRequest)this.beforeClientExecution(request);
        return this.executeCreateDetectorModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDetectorModelResult executeCreateDetectorModel(CreateDetectorModelRequest createDetectorModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDetectorModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDetectorModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDetectorModelRequestProtocolMarshaller(protocolFactory).marshall((CreateDetectorModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDetectorModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDetectorModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDetectorModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDetectorModelResult createDetectorModelResult = (CreateDetectorModelResult)response.getAwsResponse();
            return createDetectorModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateInputResult createInput(CreateInputRequest request) {
        request = (CreateInputRequest)this.beforeClientExecution(request);
        return this.executeCreateInput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateInputResult executeCreateInput(CreateInputRequest createInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateInputRequestProtocolMarshaller(protocolFactory).marshall((CreateInputRequest)super.beforeMarshalling((AmazonWebServiceRequest)createInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateInput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateInputResult createInputResult = (CreateInputResult)response.getAwsResponse();
            return createInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDetectorModelResult deleteDetectorModel(DeleteDetectorModelRequest request) {
        request = (DeleteDetectorModelRequest)this.beforeClientExecution(request);
        return this.executeDeleteDetectorModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDetectorModelResult executeDeleteDetectorModel(DeleteDetectorModelRequest deleteDetectorModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDetectorModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDetectorModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDetectorModelRequestProtocolMarshaller(protocolFactory).marshall((DeleteDetectorModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDetectorModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDetectorModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDetectorModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDetectorModelResult deleteDetectorModelResult = (DeleteDetectorModelResult)response.getAwsResponse();
            return deleteDetectorModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteInputResult deleteInput(DeleteInputRequest request) {
        request = (DeleteInputRequest)this.beforeClientExecution(request);
        return this.executeDeleteInput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteInputResult executeDeleteInput(DeleteInputRequest deleteInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteInputRequestProtocolMarshaller(protocolFactory).marshall((DeleteInputRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteInput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteInputResult deleteInputResult = (DeleteInputResult)response.getAwsResponse();
            return deleteInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDetectorModelResult describeDetectorModel(DescribeDetectorModelRequest request) {
        request = (DescribeDetectorModelRequest)this.beforeClientExecution(request);
        return this.executeDescribeDetectorModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDetectorModelResult executeDescribeDetectorModel(DescribeDetectorModelRequest describeDetectorModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDetectorModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDetectorModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDetectorModelRequestProtocolMarshaller(protocolFactory).marshall((DescribeDetectorModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDetectorModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDetectorModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDetectorModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDetectorModelResult describeDetectorModelResult = (DescribeDetectorModelResult)response.getAwsResponse();
            return describeDetectorModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeInputResult describeInput(DescribeInputRequest request) {
        request = (DescribeInputRequest)this.beforeClientExecution(request);
        return this.executeDescribeInput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeInputResult executeDescribeInput(DescribeInputRequest describeInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeInputRequestProtocolMarshaller(protocolFactory).marshall((DescribeInputRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeInput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeInputResult describeInputResult = (DescribeInputResult)response.getAwsResponse();
            return describeInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLoggingOptionsResult describeLoggingOptions(DescribeLoggingOptionsRequest request) {
        request = (DescribeLoggingOptionsRequest)this.beforeClientExecution(request);
        return this.executeDescribeLoggingOptions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeLoggingOptionsResult executeDescribeLoggingOptions(DescribeLoggingOptionsRequest describeLoggingOptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLoggingOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLoggingOptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLoggingOptionsRequestProtocolMarshaller(protocolFactory).marshall((DescribeLoggingOptionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeLoggingOptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeLoggingOptions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeLoggingOptionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLoggingOptionsResult describeLoggingOptionsResult = (DescribeLoggingOptionsResult)response.getAwsResponse();
            return describeLoggingOptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDetectorModelVersionsResult listDetectorModelVersions(ListDetectorModelVersionsRequest request) {
        request = (ListDetectorModelVersionsRequest)this.beforeClientExecution(request);
        return this.executeListDetectorModelVersions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDetectorModelVersionsResult executeListDetectorModelVersions(ListDetectorModelVersionsRequest listDetectorModelVersionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDetectorModelVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDetectorModelVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDetectorModelVersionsRequestProtocolMarshaller(protocolFactory).marshall((ListDetectorModelVersionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDetectorModelVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDetectorModelVersions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDetectorModelVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDetectorModelVersionsResult listDetectorModelVersionsResult = (ListDetectorModelVersionsResult)response.getAwsResponse();
            return listDetectorModelVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDetectorModelsResult listDetectorModels(ListDetectorModelsRequest request) {
        request = (ListDetectorModelsRequest)this.beforeClientExecution(request);
        return this.executeListDetectorModels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDetectorModelsResult executeListDetectorModels(ListDetectorModelsRequest listDetectorModelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDetectorModelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDetectorModelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDetectorModelsRequestProtocolMarshaller(protocolFactory).marshall((ListDetectorModelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDetectorModelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDetectorModels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDetectorModelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDetectorModelsResult listDetectorModelsResult = (ListDetectorModelsResult)response.getAwsResponse();
            return listDetectorModelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInputsResult listInputs(ListInputsRequest request) {
        request = (ListInputsRequest)this.beforeClientExecution(request);
        return this.executeListInputs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInputsResult executeListInputs(ListInputsRequest listInputsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInputsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInputsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInputsRequestProtocolMarshaller(protocolFactory).marshall((ListInputsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listInputsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListInputs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInputsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInputsResult listInputsResult = (ListInputsResult)response.getAwsResponse();
            return listInputsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutLoggingOptionsResult putLoggingOptions(PutLoggingOptionsRequest request) {
        request = (PutLoggingOptionsRequest)this.beforeClientExecution(request);
        return this.executePutLoggingOptions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutLoggingOptionsResult executePutLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putLoggingOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutLoggingOptionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutLoggingOptionsRequestProtocolMarshaller(protocolFactory).marshall((PutLoggingOptionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putLoggingOptionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutLoggingOptions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutLoggingOptionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutLoggingOptionsResult putLoggingOptionsResult = (PutLoggingOptionsResult)response.getAwsResponse();
            return putLoggingOptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDetectorModelResult updateDetectorModel(UpdateDetectorModelRequest request) {
        request = (UpdateDetectorModelRequest)this.beforeClientExecution(request);
        return this.executeUpdateDetectorModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDetectorModelResult executeUpdateDetectorModel(UpdateDetectorModelRequest updateDetectorModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDetectorModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDetectorModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDetectorModelRequestProtocolMarshaller(protocolFactory).marshall((UpdateDetectorModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDetectorModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDetectorModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDetectorModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDetectorModelResult updateDetectorModelResult = (UpdateDetectorModelResult)response.getAwsResponse();
            return updateDetectorModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateInputResult updateInput(UpdateInputRequest request) {
        request = (UpdateInputRequest)this.beforeClientExecution(request);
        return this.executeUpdateInput(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateInputResult executeUpdateInput(UpdateInputRequest updateInputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateInputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateInputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateInputRequestProtocolMarshaller(protocolFactory).marshall((UpdateInputRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateInputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoT Events");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateInput");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateInputResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateInputResult updateInputResult = (UpdateInputResult)response.getAwsResponse();
            return updateInputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

