/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdeviceadvisor.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotdeviceadvisor.model.SuiteRunConfiguration;
import java.util.List;

@SdkInternalApi
public class SuiteRunConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> PRIMARYDEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("primaryDevice").build();
    private static final MarshallingInfo<StructuredPojo> SECONDARYDEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secondaryDevice").build();
    private static final MarshallingInfo<List> SELECTEDTESTLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("selectedTestList").build();
    private static final SuiteRunConfigurationMarshaller instance = new SuiteRunConfigurationMarshaller();

    public static SuiteRunConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SuiteRunConfiguration suiteRunConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (suiteRunConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)suiteRunConfiguration.getPrimaryDevice(), PRIMARYDEVICE_BINDING);
            protocolMarshaller.marshall((Object)suiteRunConfiguration.getSecondaryDevice(), SECONDARYDEVICE_BINDING);
            protocolMarshaller.marshall(suiteRunConfiguration.getSelectedTestList(), SELECTEDTESTLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

