/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iotanalytics.model.PipelineActivity;
import com.amazonaws.services.iotanalytics.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreatePipelineRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String pipelineName;
    private List<PipelineActivity> pipelineActivities;
    private List<Tag> tags;

    public void setPipelineName(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public CreatePipelineRequest withPipelineName(String pipelineName) {
        this.setPipelineName(pipelineName);
        return this;
    }

    public List<PipelineActivity> getPipelineActivities() {
        return this.pipelineActivities;
    }

    public void setPipelineActivities(Collection<PipelineActivity> pipelineActivities) {
        if (pipelineActivities == null) {
            this.pipelineActivities = null;
            return;
        }
        this.pipelineActivities = new ArrayList<PipelineActivity>(pipelineActivities);
    }

    public CreatePipelineRequest withPipelineActivities(PipelineActivity ... pipelineActivities) {
        if (this.pipelineActivities == null) {
            this.setPipelineActivities(new ArrayList<PipelineActivity>(pipelineActivities.length));
        }
        for (PipelineActivity ele : pipelineActivities) {
            this.pipelineActivities.add(ele);
        }
        return this;
    }

    public CreatePipelineRequest withPipelineActivities(Collection<PipelineActivity> pipelineActivities) {
        this.setPipelineActivities(pipelineActivities);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreatePipelineRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreatePipelineRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineName() != null) {
            sb.append("PipelineName: ").append(this.getPipelineName()).append(",");
        }
        if (this.getPipelineActivities() != null) {
            sb.append("PipelineActivities: ").append(this.getPipelineActivities()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineRequest)) {
            return false;
        }
        CreatePipelineRequest other = (CreatePipelineRequest)obj;
        if (other.getPipelineName() == null ^ this.getPipelineName() == null) {
            return false;
        }
        if (other.getPipelineName() != null && !other.getPipelineName().equals(this.getPipelineName())) {
            return false;
        }
        if (other.getPipelineActivities() == null ^ this.getPipelineActivities() == null) {
            return false;
        }
        if (other.getPipelineActivities() != null && !other.getPipelineActivities().equals(this.getPipelineActivities())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineName() == null ? 0 : this.getPipelineName().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineActivities() == null ? 0 : this.getPipelineActivities().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreatePipelineRequest clone() {
        return (CreatePipelineRequest)super.clone();
    }
}

