/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iot.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * The input to the RegisterCACertificate operation.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RegisterCACertificateRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The CA certificate.
     * </p>
     */
    private String caCertificate;
    /**
     * <p>
     * The private key verification certificate. If <code>certificateMode</code> is <code>SNI_ONLY</code>, the
     * <code>verificationCertificate</code> field must be empty. If <code>certificateMode</code> is <code>DEFAULT</code>
     * or not provided, the <code>verificationCertificate</code> field must not be empty.
     * </p>
     */
    private String verificationCertificate;
    /**
     * <p>
     * A boolean value that specifies if the CA certificate is set to active.
     * </p>
     * <p>
     * Valid values: <code>ACTIVE | INACTIVE</code>
     * </p>
     */
    private Boolean setAsActive;
    /**
     * <p>
     * Allows this CA certificate to be used for auto registration of device certificates.
     * </p>
     */
    private Boolean allowAutoRegistration;
    /**
     * <p>
     * Information about the registration configuration.
     * </p>
     */
    private RegistrationConfig registrationConfig;
    /**
     * <p>
     * Metadata which can be used to manage the CA certificate.
     * </p>
     * <note>
     * <p>
     * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     * </p>
     * <p>
     * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     * </p>
     * <p>
     * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     * </p>
     * </note>
     */
    private java.util.List<Tag> tags;
    /**
     * <p>
     * Describes the certificate mode in which the Certificate Authority (CA) will be registered. If the
     * <code>verificationCertificate</code> field is not provided, set <code>certificateMode</code> to be
     * <code>SNI_ONLY</code>. If the <code>verificationCertificate</code> field is provided, set
     * <code>certificateMode</code> to be <code>DEFAULT</code>. When <code>certificateMode</code> is not provided, it
     * defaults to <code>DEFAULT</code>. All the device certificates that are registered using this CA will be
     * registered in the same certificate mode as the CA. For more information about certificate mode for device
     * certificates, see <a href=
     * "https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode"
     * > certificate mode</a>.
     * </p>
     */
    private String certificateMode;

    /**
     * <p>
     * The CA certificate.
     * </p>
     * 
     * @param caCertificate
     *        The CA certificate.
     */

    public void setCaCertificate(String caCertificate) {
        this.caCertificate = caCertificate;
    }

    /**
     * <p>
     * The CA certificate.
     * </p>
     * 
     * @return The CA certificate.
     */

    public String getCaCertificate() {
        return this.caCertificate;
    }

    /**
     * <p>
     * The CA certificate.
     * </p>
     * 
     * @param caCertificate
     *        The CA certificate.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterCACertificateRequest withCaCertificate(String caCertificate) {
        setCaCertificate(caCertificate);
        return this;
    }

    /**
     * <p>
     * The private key verification certificate. If <code>certificateMode</code> is <code>SNI_ONLY</code>, the
     * <code>verificationCertificate</code> field must be empty. If <code>certificateMode</code> is <code>DEFAULT</code>
     * or not provided, the <code>verificationCertificate</code> field must not be empty.
     * </p>
     * 
     * @param verificationCertificate
     *        The private key verification certificate. If <code>certificateMode</code> is <code>SNI_ONLY</code>, the
     *        <code>verificationCertificate</code> field must be empty. If <code>certificateMode</code> is
     *        <code>DEFAULT</code> or not provided, the <code>verificationCertificate</code> field must not be empty.
     */

    public void setVerificationCertificate(String verificationCertificate) {
        this.verificationCertificate = verificationCertificate;
    }

    /**
     * <p>
     * The private key verification certificate. If <code>certificateMode</code> is <code>SNI_ONLY</code>, the
     * <code>verificationCertificate</code> field must be empty. If <code>certificateMode</code> is <code>DEFAULT</code>
     * or not provided, the <code>verificationCertificate</code> field must not be empty.
     * </p>
     * 
     * @return The private key verification certificate. If <code>certificateMode</code> is <code>SNI_ONLY</code>, the
     *         <code>verificationCertificate</code> field must be empty. If <code>certificateMode</code> is
     *         <code>DEFAULT</code> or not provided, the <code>verificationCertificate</code> field must not be empty.
     */

    public String getVerificationCertificate() {
        return this.verificationCertificate;
    }

    /**
     * <p>
     * The private key verification certificate. If <code>certificateMode</code> is <code>SNI_ONLY</code>, the
     * <code>verificationCertificate</code> field must be empty. If <code>certificateMode</code> is <code>DEFAULT</code>
     * or not provided, the <code>verificationCertificate</code> field must not be empty.
     * </p>
     * 
     * @param verificationCertificate
     *        The private key verification certificate. If <code>certificateMode</code> is <code>SNI_ONLY</code>, the
     *        <code>verificationCertificate</code> field must be empty. If <code>certificateMode</code> is
     *        <code>DEFAULT</code> or not provided, the <code>verificationCertificate</code> field must not be empty.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterCACertificateRequest withVerificationCertificate(String verificationCertificate) {
        setVerificationCertificate(verificationCertificate);
        return this;
    }

    /**
     * <p>
     * A boolean value that specifies if the CA certificate is set to active.
     * </p>
     * <p>
     * Valid values: <code>ACTIVE | INACTIVE</code>
     * </p>
     * 
     * @param setAsActive
     *        A boolean value that specifies if the CA certificate is set to active.</p>
     *        <p>
     *        Valid values: <code>ACTIVE | INACTIVE</code>
     */

    public void setSetAsActive(Boolean setAsActive) {
        this.setAsActive = setAsActive;
    }

    /**
     * <p>
     * A boolean value that specifies if the CA certificate is set to active.
     * </p>
     * <p>
     * Valid values: <code>ACTIVE | INACTIVE</code>
     * </p>
     * 
     * @return A boolean value that specifies if the CA certificate is set to active.</p>
     *         <p>
     *         Valid values: <code>ACTIVE | INACTIVE</code>
     */

    public Boolean getSetAsActive() {
        return this.setAsActive;
    }

    /**
     * <p>
     * A boolean value that specifies if the CA certificate is set to active.
     * </p>
     * <p>
     * Valid values: <code>ACTIVE | INACTIVE</code>
     * </p>
     * 
     * @param setAsActive
     *        A boolean value that specifies if the CA certificate is set to active.</p>
     *        <p>
     *        Valid values: <code>ACTIVE | INACTIVE</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterCACertificateRequest withSetAsActive(Boolean setAsActive) {
        setSetAsActive(setAsActive);
        return this;
    }

    /**
     * <p>
     * A boolean value that specifies if the CA certificate is set to active.
     * </p>
     * <p>
     * Valid values: <code>ACTIVE | INACTIVE</code>
     * </p>
     * 
     * @return A boolean value that specifies if the CA certificate is set to active.</p>
     *         <p>
     *         Valid values: <code>ACTIVE | INACTIVE</code>
     */

    public Boolean isSetAsActive() {
        return this.setAsActive;
    }

    /**
     * <p>
     * Allows this CA certificate to be used for auto registration of device certificates.
     * </p>
     * 
     * @param allowAutoRegistration
     *        Allows this CA certificate to be used for auto registration of device certificates.
     */

    public void setAllowAutoRegistration(Boolean allowAutoRegistration) {
        this.allowAutoRegistration = allowAutoRegistration;
    }

    /**
     * <p>
     * Allows this CA certificate to be used for auto registration of device certificates.
     * </p>
     * 
     * @return Allows this CA certificate to be used for auto registration of device certificates.
     */

    public Boolean getAllowAutoRegistration() {
        return this.allowAutoRegistration;
    }

    /**
     * <p>
     * Allows this CA certificate to be used for auto registration of device certificates.
     * </p>
     * 
     * @param allowAutoRegistration
     *        Allows this CA certificate to be used for auto registration of device certificates.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterCACertificateRequest withAllowAutoRegistration(Boolean allowAutoRegistration) {
        setAllowAutoRegistration(allowAutoRegistration);
        return this;
    }

    /**
     * <p>
     * Allows this CA certificate to be used for auto registration of device certificates.
     * </p>
     * 
     * @return Allows this CA certificate to be used for auto registration of device certificates.
     */

    public Boolean isAllowAutoRegistration() {
        return this.allowAutoRegistration;
    }

    /**
     * <p>
     * Information about the registration configuration.
     * </p>
     * 
     * @param registrationConfig
     *        Information about the registration configuration.
     */

    public void setRegistrationConfig(RegistrationConfig registrationConfig) {
        this.registrationConfig = registrationConfig;
    }

    /**
     * <p>
     * Information about the registration configuration.
     * </p>
     * 
     * @return Information about the registration configuration.
     */

    public RegistrationConfig getRegistrationConfig() {
        return this.registrationConfig;
    }

    /**
     * <p>
     * Information about the registration configuration.
     * </p>
     * 
     * @param registrationConfig
     *        Information about the registration configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterCACertificateRequest withRegistrationConfig(RegistrationConfig registrationConfig) {
        setRegistrationConfig(registrationConfig);
        return this;
    }

    /**
     * <p>
     * Metadata which can be used to manage the CA certificate.
     * </p>
     * <note>
     * <p>
     * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     * </p>
     * <p>
     * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     * </p>
     * <p>
     * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     * </p>
     * </note>
     * 
     * @return Metadata which can be used to manage the CA certificate.</p> <note>
     *         <p>
     *         For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     *         </p>
     *         <p>
     *         For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     *         </p>
     *         <p>
     *         For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     *         </p>
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * <p>
     * Metadata which can be used to manage the CA certificate.
     * </p>
     * <note>
     * <p>
     * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     * </p>
     * <p>
     * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     * </p>
     * <p>
     * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     * </p>
     * </note>
     * 
     * @param tags
     *        Metadata which can be used to manage the CA certificate.</p> <note>
     *        <p>
     *        For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     *        </p>
     *        <p>
     *        For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     *        </p>
     *        <p>
     *        For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     *        </p>
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * Metadata which can be used to manage the CA certificate.
     * </p>
     * <note>
     * <p>
     * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     * </p>
     * <p>
     * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     * </p>
     * <p>
     * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     * </p>
     * </note>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        Metadata which can be used to manage the CA certificate.</p> <note>
     *        <p>
     *        For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     *        </p>
     *        <p>
     *        For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     *        </p>
     *        <p>
     *        For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterCACertificateRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Metadata which can be used to manage the CA certificate.
     * </p>
     * <note>
     * <p>
     * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     * </p>
     * <p>
     * For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     * </p>
     * <p>
     * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     * </p>
     * </note>
     * 
     * @param tags
     *        Metadata which can be used to manage the CA certificate.</p> <note>
     *        <p>
     *        For URI Request parameters use format: ...key1=value1&amp;key2=value2...
     *        </p>
     *        <p>
     *        For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."
     *        </p>
     *        <p>
     *        For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegisterCACertificateRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * <p>
     * Describes the certificate mode in which the Certificate Authority (CA) will be registered. If the
     * <code>verificationCertificate</code> field is not provided, set <code>certificateMode</code> to be
     * <code>SNI_ONLY</code>. If the <code>verificationCertificate</code> field is provided, set
     * <code>certificateMode</code> to be <code>DEFAULT</code>. When <code>certificateMode</code> is not provided, it
     * defaults to <code>DEFAULT</code>. All the device certificates that are registered using this CA will be
     * registered in the same certificate mode as the CA. For more information about certificate mode for device
     * certificates, see <a href=
     * "https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode"
     * > certificate mode</a>.
     * </p>
     * 
     * @param certificateMode
     *        Describes the certificate mode in which the Certificate Authority (CA) will be registered. If the
     *        <code>verificationCertificate</code> field is not provided, set <code>certificateMode</code> to be
     *        <code>SNI_ONLY</code>. If the <code>verificationCertificate</code> field is provided, set
     *        <code>certificateMode</code> to be <code>DEFAULT</code>. When <code>certificateMode</code> is not
     *        provided, it defaults to <code>DEFAULT</code>. All the device certificates that are registered using this
     *        CA will be registered in the same certificate mode as the CA. For more information about certificate mode
     *        for device certificates, see <a href=
     *        "https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode"
     *        > certificate mode</a>.
     * @see CertificateMode
     */

    public void setCertificateMode(String certificateMode) {
        this.certificateMode = certificateMode;
    }

    /**
     * <p>
     * Describes the certificate mode in which the Certificate Authority (CA) will be registered. If the
     * <code>verificationCertificate</code> field is not provided, set <code>certificateMode</code> to be
     * <code>SNI_ONLY</code>. If the <code>verificationCertificate</code> field is provided, set
     * <code>certificateMode</code> to be <code>DEFAULT</code>. When <code>certificateMode</code> is not provided, it
     * defaults to <code>DEFAULT</code>. All the device certificates that are registered using this CA will be
     * registered in the same certificate mode as the CA. For more information about certificate mode for device
     * certificates, see <a href=
     * "https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode"
     * > certificate mode</a>.
     * </p>
     * 
     * @return Describes the certificate mode in which the Certificate Authority (CA) will be registered. If the
     *         <code>verificationCertificate</code> field is not provided, set <code>certificateMode</code> to be
     *         <code>SNI_ONLY</code>. If the <code>verificationCertificate</code> field is provided, set
     *         <code>certificateMode</code> to be <code>DEFAULT</code>. When <code>certificateMode</code> is not
     *         provided, it defaults to <code>DEFAULT</code>. All the device certificates that are registered using this
     *         CA will be registered in the same certificate mode as the CA. For more information about certificate mode
     *         for device certificates, see <a href=
     *         "https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode"
     *         > certificate mode</a>.
     * @see CertificateMode
     */

    public String getCertificateMode() {
        return this.certificateMode;
    }

    /**
     * <p>
     * Describes the certificate mode in which the Certificate Authority (CA) will be registered. If the
     * <code>verificationCertificate</code> field is not provided, set <code>certificateMode</code> to be
     * <code>SNI_ONLY</code>. If the <code>verificationCertificate</code> field is provided, set
     * <code>certificateMode</code> to be <code>DEFAULT</code>. When <code>certificateMode</code> is not provided, it
     * defaults to <code>DEFAULT</code>. All the device certificates that are registered using this CA will be
     * registered in the same certificate mode as the CA. For more information about certificate mode for device
     * certificates, see <a href=
     * "https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode"
     * > certificate mode</a>.
     * </p>
     * 
     * @param certificateMode
     *        Describes the certificate mode in which the Certificate Authority (CA) will be registered. If the
     *        <code>verificationCertificate</code> field is not provided, set <code>certificateMode</code> to be
     *        <code>SNI_ONLY</code>. If the <code>verificationCertificate</code> field is provided, set
     *        <code>certificateMode</code> to be <code>DEFAULT</code>. When <code>certificateMode</code> is not
     *        provided, it defaults to <code>DEFAULT</code>. All the device certificates that are registered using this
     *        CA will be registered in the same certificate mode as the CA. For more information about certificate mode
     *        for device certificates, see <a href=
     *        "https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode"
     *        > certificate mode</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CertificateMode
     */

    public RegisterCACertificateRequest withCertificateMode(String certificateMode) {
        setCertificateMode(certificateMode);
        return this;
    }

    /**
     * <p>
     * Describes the certificate mode in which the Certificate Authority (CA) will be registered. If the
     * <code>verificationCertificate</code> field is not provided, set <code>certificateMode</code> to be
     * <code>SNI_ONLY</code>. If the <code>verificationCertificate</code> field is provided, set
     * <code>certificateMode</code> to be <code>DEFAULT</code>. When <code>certificateMode</code> is not provided, it
     * defaults to <code>DEFAULT</code>. All the device certificates that are registered using this CA will be
     * registered in the same certificate mode as the CA. For more information about certificate mode for device
     * certificates, see <a href=
     * "https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode"
     * > certificate mode</a>.
     * </p>
     * 
     * @param certificateMode
     *        Describes the certificate mode in which the Certificate Authority (CA) will be registered. If the
     *        <code>verificationCertificate</code> field is not provided, set <code>certificateMode</code> to be
     *        <code>SNI_ONLY</code>. If the <code>verificationCertificate</code> field is provided, set
     *        <code>certificateMode</code> to be <code>DEFAULT</code>. When <code>certificateMode</code> is not
     *        provided, it defaults to <code>DEFAULT</code>. All the device certificates that are registered using this
     *        CA will be registered in the same certificate mode as the CA. For more information about certificate mode
     *        for device certificates, see <a href=
     *        "https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode"
     *        > certificate mode</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CertificateMode
     */

    public RegisterCACertificateRequest withCertificateMode(CertificateMode certificateMode) {
        this.certificateMode = certificateMode.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCaCertificate() != null)
            sb.append("CaCertificate: ").append(getCaCertificate()).append(",");
        if (getVerificationCertificate() != null)
            sb.append("VerificationCertificate: ").append(getVerificationCertificate()).append(",");
        if (getSetAsActive() != null)
            sb.append("SetAsActive: ").append(getSetAsActive()).append(",");
        if (getAllowAutoRegistration() != null)
            sb.append("AllowAutoRegistration: ").append(getAllowAutoRegistration()).append(",");
        if (getRegistrationConfig() != null)
            sb.append("RegistrationConfig: ").append(getRegistrationConfig()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getCertificateMode() != null)
            sb.append("CertificateMode: ").append(getCertificateMode());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RegisterCACertificateRequest == false)
            return false;
        RegisterCACertificateRequest other = (RegisterCACertificateRequest) obj;
        if (other.getCaCertificate() == null ^ this.getCaCertificate() == null)
            return false;
        if (other.getCaCertificate() != null && other.getCaCertificate().equals(this.getCaCertificate()) == false)
            return false;
        if (other.getVerificationCertificate() == null ^ this.getVerificationCertificate() == null)
            return false;
        if (other.getVerificationCertificate() != null && other.getVerificationCertificate().equals(this.getVerificationCertificate()) == false)
            return false;
        if (other.getSetAsActive() == null ^ this.getSetAsActive() == null)
            return false;
        if (other.getSetAsActive() != null && other.getSetAsActive().equals(this.getSetAsActive()) == false)
            return false;
        if (other.getAllowAutoRegistration() == null ^ this.getAllowAutoRegistration() == null)
            return false;
        if (other.getAllowAutoRegistration() != null && other.getAllowAutoRegistration().equals(this.getAllowAutoRegistration()) == false)
            return false;
        if (other.getRegistrationConfig() == null ^ this.getRegistrationConfig() == null)
            return false;
        if (other.getRegistrationConfig() != null && other.getRegistrationConfig().equals(this.getRegistrationConfig()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getCertificateMode() == null ^ this.getCertificateMode() == null)
            return false;
        if (other.getCertificateMode() != null && other.getCertificateMode().equals(this.getCertificateMode()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCaCertificate() == null) ? 0 : getCaCertificate().hashCode());
        hashCode = prime * hashCode + ((getVerificationCertificate() == null) ? 0 : getVerificationCertificate().hashCode());
        hashCode = prime * hashCode + ((getSetAsActive() == null) ? 0 : getSetAsActive().hashCode());
        hashCode = prime * hashCode + ((getAllowAutoRegistration() == null) ? 0 : getAllowAutoRegistration().hashCode());
        hashCode = prime * hashCode + ((getRegistrationConfig() == null) ? 0 : getRegistrationConfig().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getCertificateMode() == null) ? 0 : getCertificateMode().hashCode());
        return hashCode;
    }

    @Override
    public RegisterCACertificateRequest clone() {
        return (RegisterCACertificateRequest) super.clone();
    }

}
