/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.ListThingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListThingsRequestMarshaller
implements Marshaller<Request<ListThingsRequest>, ListThingsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public ListThingsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListThingsRequest> marshall(ListThingsRequest listThingsRequest) {
        if (listThingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listThingsRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/things";
        request.setResourcePath(uriResourcePath);
        if (listThingsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listThingsRequest.getNextToken()));
        }
        if (listThingsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listThingsRequest.getMaxResults()));
        }
        if (listThingsRequest.getAttributeName() != null) {
            request.addParameter("attributeName", StringUtils.fromString((String)listThingsRequest.getAttributeName()));
        }
        if (listThingsRequest.getAttributeValue() != null) {
            request.addParameter("attributeValue", StringUtils.fromString((String)listThingsRequest.getAttributeValue()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

