/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.ThingAttribute;
import java.util.Map;

public class ThingAttributeJsonMarshaller {
    private static ThingAttributeJsonMarshaller instance;

    public void marshall(ThingAttribute thingAttribute, StructuredJsonGenerator jsonGenerator) {
        if (thingAttribute == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> attributesMap;
            jsonGenerator.writeStartObject();
            if (thingAttribute.getThingName() != null) {
                jsonGenerator.writeFieldName("thingName").writeValue(thingAttribute.getThingName());
            }
            if (thingAttribute.getThingTypeName() != null) {
                jsonGenerator.writeFieldName("thingTypeName").writeValue(thingAttribute.getThingTypeName());
            }
            if ((attributesMap = thingAttribute.getAttributes()) != null) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(attributesMapValue.getKey());
                    jsonGenerator.writeValue(attributesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (thingAttribute.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(thingAttribute.getVersion().longValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ThingAttributeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ThingAttributeJsonMarshaller();
        }
        return instance;
    }
}

