/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.DescribeThingTypeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeThingTypeRequestMarshaller
implements Marshaller<Request<DescribeThingTypeRequest>, DescribeThingTypeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeThingTypeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeThingTypeRequest> marshall(DescribeThingTypeRequest describeThingTypeRequest) {
        if (describeThingTypeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeThingTypeRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/thing-types/{thingTypeName}";
        uriResourcePath = uriResourcePath.replace("{thingTypeName}", describeThingTypeRequest.getThingTypeName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)describeThingTypeRequest.getThingTypeName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

