/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.CreateThingRequest;
import com.amazonaws.services.iot.model.transform.AttributePayloadJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateThingRequestMarshaller
implements Marshaller<Request<CreateThingRequest>, CreateThingRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateThingRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateThingRequest> marshall(CreateThingRequest createThingRequest) {
        if (createThingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createThingRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/things/{thingName}";
        uriResourcePath = uriResourcePath.replace("{thingName}", createThingRequest.getThingName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)createThingRequest.getThingName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createThingRequest.getThingTypeName() != null) {
                jsonGenerator.writeFieldName("thingTypeName").writeValue(createThingRequest.getThingTypeName());
            }
            if (createThingRequest.getAttributePayload() != null) {
                jsonGenerator.writeFieldName("attributePayload");
                AttributePayloadJsonMarshaller.getInstance().marshall(createThingRequest.getAttributePayload(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

