/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.DeletePolicyVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeletePolicyVersionRequestMarshaller
implements Marshaller<Request<DeletePolicyVersionRequest>, DeletePolicyVersionRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public DeletePolicyVersionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeletePolicyVersionRequest> marshall(DeletePolicyVersionRequest deletePolicyVersionRequest) {
        if (deletePolicyVersionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deletePolicyVersionRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/policies/{policyName}/version/{policyVersionId}";
        uriResourcePath = uriResourcePath.replace("{policyName}", deletePolicyVersionRequest.getPolicyName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deletePolicyVersionRequest.getPolicyName()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{policyVersionId}", deletePolicyVersionRequest.getPolicyVersionId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deletePolicyVersionRequest.getPolicyVersionId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

