/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdata;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.iotdata.AWSIotData;
import com.amazonaws.services.iotdata.model.ConflictException;
import com.amazonaws.services.iotdata.model.DeleteThingShadowRequest;
import com.amazonaws.services.iotdata.model.DeleteThingShadowResult;
import com.amazonaws.services.iotdata.model.GetThingShadowRequest;
import com.amazonaws.services.iotdata.model.GetThingShadowResult;
import com.amazonaws.services.iotdata.model.InternalFailureException;
import com.amazonaws.services.iotdata.model.InvalidRequestException;
import com.amazonaws.services.iotdata.model.MethodNotAllowedException;
import com.amazonaws.services.iotdata.model.PublishRequest;
import com.amazonaws.services.iotdata.model.RequestEntityTooLargeException;
import com.amazonaws.services.iotdata.model.ResourceNotFoundException;
import com.amazonaws.services.iotdata.model.ServiceUnavailableException;
import com.amazonaws.services.iotdata.model.ThrottlingException;
import com.amazonaws.services.iotdata.model.UnauthorizedException;
import com.amazonaws.services.iotdata.model.UnsupportedDocumentEncodingException;
import com.amazonaws.services.iotdata.model.UpdateThingShadowRequest;
import com.amazonaws.services.iotdata.model.UpdateThingShadowResult;
import com.amazonaws.services.iotdata.model.transform.DeleteThingShadowRequestMarshaller;
import com.amazonaws.services.iotdata.model.transform.DeleteThingShadowResultJsonUnmarshaller;
import com.amazonaws.services.iotdata.model.transform.GetThingShadowRequestMarshaller;
import com.amazonaws.services.iotdata.model.transform.GetThingShadowResultJsonUnmarshaller;
import com.amazonaws.services.iotdata.model.transform.PublishRequestMarshaller;
import com.amazonaws.services.iotdata.model.transform.UpdateThingShadowRequestMarshaller;
import com.amazonaws.services.iotdata.model.transform.UpdateThingShadowResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSIotDataClient
extends AmazonWebServiceClient
implements AWSIotData {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSIotData.class);
    private static final String DEFAULT_SIGNING_NAME = "iotdata";
    private static final String DEFAULT_ENDPOINT_PREFIX = "data.iot";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AWSIotDataClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AWSIotDataClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSIotDataClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AWSIotDataClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSIotDataClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AWSIotDataClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSIotDataClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(UnauthorizedException.class, "UnauthorizedException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(MethodNotAllowedException.class, "MethodNotAllowedException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ConflictException.class, "ConflictException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RequestEntityTooLargeException.class, "RequestEntityTooLargeException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(UnsupportedDocumentEncodingException.class, "UnsupportedDocumentEncodingException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ThrottlingException.class, "ThrottlingException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ServiceUnavailableException.class, "ServiceUnavailableException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ResourceNotFoundException.class, "ResourceNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InternalFailureException.class, "InternalFailureException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRequestException.class, "InvalidRequestException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_ENDPOINT_PREFIX);
        this.setEndpoint("https://data.iot.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/iotdata/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/iotdata/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteThingShadowResult deleteThingShadow(DeleteThingShadowRequest deleteThingShadowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteThingShadowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteThingShadowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteThingShadowRequestMarshaller().marshall((DeleteThingShadowRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteThingShadowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DeleteThingShadowResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(false);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteThingShadowResult deleteThingShadowResult = (DeleteThingShadowResult)response.getAwsResponse();
            return deleteThingShadowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetThingShadowResult getThingShadow(GetThingShadowRequest getThingShadowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getThingShadowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetThingShadowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetThingShadowRequestMarshaller().marshall((GetThingShadowRequest)super.beforeMarshalling((AmazonWebServiceRequest)getThingShadowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetThingShadowResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(false);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetThingShadowResult getThingShadowResult = (GetThingShadowResult)response.getAwsResponse();
            return getThingShadowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(PublishRequest publishRequest) {
        ExecutionContext executionContext = this.createExecutionContext(publishRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PublishRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PublishRequestMarshaller().marshall((PublishRequest)super.beforeMarshalling((AmazonWebServiceRequest)publishRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateThingShadowResult updateThingShadow(UpdateThingShadowRequest updateThingShadowRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateThingShadowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateThingShadowRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateThingShadowRequestMarshaller().marshall((UpdateThingShadowRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateThingShadowRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateThingShadowResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(false);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateThingShadowResult updateThingShadowResult = (UpdateThingShadowResult)response.getAwsResponse();
            return updateThingShadowResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

