/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.CreatePolicyVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreatePolicyVersionRequestMarshaller
implements Marshaller<Request<CreatePolicyVersionRequest>, CreatePolicyVersionRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<CreatePolicyVersionRequest> marshall(CreatePolicyVersionRequest createPolicyVersionRequest) {
        String setAsDefault;
        if (createPolicyVersionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPolicyVersionRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/policies/{policyName}/version";
        uriResourcePath = uriResourcePath.replace("{policyName}", createPolicyVersionRequest.getPolicyName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)createPolicyVersionRequest.getPolicyName()));
        request.setResourcePath(uriResourcePath);
        String string = setAsDefault = createPolicyVersionRequest.getSetAsDefault() == null ? null : StringUtils.fromBoolean((Boolean)createPolicyVersionRequest.getSetAsDefault());
        if (setAsDefault != null) {
            request.addParameter("setAsDefault", setAsDefault);
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createPolicyVersionRequest.getPolicyDocument() != null) {
                jsonWriter.key("policyDocument").value((Object)createPolicyVersionRequest.getPolicyDocument());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

