/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListFindingAggregationsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Web Services account IDs to retrieve finding aggregation data for.
     * </p>
     */
    private java.util.List<StringFilter> accountIds;
    /**
     * <p>
     * Details of the aggregation request that is used to filter your aggregation results.
     * </p>
     */
    private AggregationRequest aggregationRequest;
    /**
     * <p>
     * The type of the aggregation request.
     * </p>
     */
    private String aggregationType;
    /**
     * <p>
     * The maximum number of results the response can return. If your request would return more than the maximum the
     * response will return a <code>nextToken</code> value, use this value when you call the action again to get the
     * remaining results.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum
     * value it will also return a <code>nextToken</code> value. For subsequent calls, use the <code>nextToken</code>
     * value returned from the previous request to continue listing results after the first page.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * The Amazon Web Services account IDs to retrieve finding aggregation data for.
     * </p>
     * 
     * @return The Amazon Web Services account IDs to retrieve finding aggregation data for.
     */

    public java.util.List<StringFilter> getAccountIds() {
        return accountIds;
    }

    /**
     * <p>
     * The Amazon Web Services account IDs to retrieve finding aggregation data for.
     * </p>
     * 
     * @param accountIds
     *        The Amazon Web Services account IDs to retrieve finding aggregation data for.
     */

    public void setAccountIds(java.util.Collection<StringFilter> accountIds) {
        if (accountIds == null) {
            this.accountIds = null;
            return;
        }

        this.accountIds = new java.util.ArrayList<StringFilter>(accountIds);
    }

    /**
     * <p>
     * The Amazon Web Services account IDs to retrieve finding aggregation data for.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAccountIds(java.util.Collection)} or {@link #withAccountIds(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param accountIds
     *        The Amazon Web Services account IDs to retrieve finding aggregation data for.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListFindingAggregationsRequest withAccountIds(StringFilter... accountIds) {
        if (this.accountIds == null) {
            setAccountIds(new java.util.ArrayList<StringFilter>(accountIds.length));
        }
        for (StringFilter ele : accountIds) {
            this.accountIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The Amazon Web Services account IDs to retrieve finding aggregation data for.
     * </p>
     * 
     * @param accountIds
     *        The Amazon Web Services account IDs to retrieve finding aggregation data for.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListFindingAggregationsRequest withAccountIds(java.util.Collection<StringFilter> accountIds) {
        setAccountIds(accountIds);
        return this;
    }

    /**
     * <p>
     * Details of the aggregation request that is used to filter your aggregation results.
     * </p>
     * 
     * @param aggregationRequest
     *        Details of the aggregation request that is used to filter your aggregation results.
     */

    public void setAggregationRequest(AggregationRequest aggregationRequest) {
        this.aggregationRequest = aggregationRequest;
    }

    /**
     * <p>
     * Details of the aggregation request that is used to filter your aggregation results.
     * </p>
     * 
     * @return Details of the aggregation request that is used to filter your aggregation results.
     */

    public AggregationRequest getAggregationRequest() {
        return this.aggregationRequest;
    }

    /**
     * <p>
     * Details of the aggregation request that is used to filter your aggregation results.
     * </p>
     * 
     * @param aggregationRequest
     *        Details of the aggregation request that is used to filter your aggregation results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListFindingAggregationsRequest withAggregationRequest(AggregationRequest aggregationRequest) {
        setAggregationRequest(aggregationRequest);
        return this;
    }

    /**
     * <p>
     * The type of the aggregation request.
     * </p>
     * 
     * @param aggregationType
     *        The type of the aggregation request.
     * @see AggregationType
     */

    public void setAggregationType(String aggregationType) {
        this.aggregationType = aggregationType;
    }

    /**
     * <p>
     * The type of the aggregation request.
     * </p>
     * 
     * @return The type of the aggregation request.
     * @see AggregationType
     */

    public String getAggregationType() {
        return this.aggregationType;
    }

    /**
     * <p>
     * The type of the aggregation request.
     * </p>
     * 
     * @param aggregationType
     *        The type of the aggregation request.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AggregationType
     */

    public ListFindingAggregationsRequest withAggregationType(String aggregationType) {
        setAggregationType(aggregationType);
        return this;
    }

    /**
     * <p>
     * The type of the aggregation request.
     * </p>
     * 
     * @param aggregationType
     *        The type of the aggregation request.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AggregationType
     */

    public ListFindingAggregationsRequest withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType.toString();
        return this;
    }

    /**
     * <p>
     * The maximum number of results the response can return. If your request would return more than the maximum the
     * response will return a <code>nextToken</code> value, use this value when you call the action again to get the
     * remaining results.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results the response can return. If your request would return more than the maximum
     *        the response will return a <code>nextToken</code> value, use this value when you call the action again to
     *        get the remaining results.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results the response can return. If your request would return more than the maximum the
     * response will return a <code>nextToken</code> value, use this value when you call the action again to get the
     * remaining results.
     * </p>
     * 
     * @return The maximum number of results the response can return. If your request would return more than the maximum
     *         the response will return a <code>nextToken</code> value, use this value when you call the action again to
     *         get the remaining results.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results the response can return. If your request would return more than the maximum the
     * response will return a <code>nextToken</code> value, use this value when you call the action again to get the
     * remaining results.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results the response can return. If your request would return more than the maximum
     *        the response will return a <code>nextToken</code> value, use this value when you call the action again to
     *        get the remaining results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListFindingAggregationsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum
     * value it will also return a <code>nextToken</code> value. For subsequent calls, use the <code>nextToken</code>
     * value returned from the previous request to continue listing results after the first page.
     * </p>
     * 
     * @param nextToken
     *        A token to use for paginating results that are returned in the response. Set the value of this parameter
     *        to null for the first request to a list action. If your response returns more than the
     *        <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For subsequent
     *        calls, use the <code>nextToken</code> value returned from the previous request to continue listing results
     *        after the first page.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum
     * value it will also return a <code>nextToken</code> value. For subsequent calls, use the <code>nextToken</code>
     * value returned from the previous request to continue listing results after the first page.
     * </p>
     * 
     * @return A token to use for paginating results that are returned in the response. Set the value of this parameter
     *         to null for the first request to a list action. If your response returns more than the
     *         <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For subsequent
     *         calls, use the <code>nextToken</code> value returned from the previous request to continue listing
     *         results after the first page.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum
     * value it will also return a <code>nextToken</code> value. For subsequent calls, use the <code>nextToken</code>
     * value returned from the previous request to continue listing results after the first page.
     * </p>
     * 
     * @param nextToken
     *        A token to use for paginating results that are returned in the response. Set the value of this parameter
     *        to null for the first request to a list action. If your response returns more than the
     *        <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For subsequent
     *        calls, use the <code>nextToken</code> value returned from the previous request to continue listing results
     *        after the first page.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListFindingAggregationsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAccountIds() != null)
            sb.append("AccountIds: ").append(getAccountIds()).append(",");
        if (getAggregationRequest() != null)
            sb.append("AggregationRequest: ").append(getAggregationRequest()).append(",");
        if (getAggregationType() != null)
            sb.append("AggregationType: ").append(getAggregationType()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListFindingAggregationsRequest == false)
            return false;
        ListFindingAggregationsRequest other = (ListFindingAggregationsRequest) obj;
        if (other.getAccountIds() == null ^ this.getAccountIds() == null)
            return false;
        if (other.getAccountIds() != null && other.getAccountIds().equals(this.getAccountIds()) == false)
            return false;
        if (other.getAggregationRequest() == null ^ this.getAggregationRequest() == null)
            return false;
        if (other.getAggregationRequest() != null && other.getAggregationRequest().equals(this.getAggregationRequest()) == false)
            return false;
        if (other.getAggregationType() == null ^ this.getAggregationType() == null)
            return false;
        if (other.getAggregationType() != null && other.getAggregationType().equals(this.getAggregationType()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAccountIds() == null) ? 0 : getAccountIds().hashCode());
        hashCode = prime * hashCode + ((getAggregationRequest() == null) ? 0 : getAggregationRequest().hashCode());
        hashCode = prime * hashCode + ((getAggregationType() == null) ? 0 : getAggregationType().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListFindingAggregationsRequest clone() {
        return (ListFindingAggregationsRequest) super.clone();
    }

}
