/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.inspector2.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Vulnerability JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class VulnerabilityJsonUnmarshaller implements Unmarshaller<Vulnerability, JsonUnmarshallerContext> {

    public Vulnerability unmarshall(JsonUnmarshallerContext context) throws Exception {
        Vulnerability vulnerability = new Vulnerability();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("atigData", targetDepth)) {
                    context.nextToken();
                    vulnerability.setAtigData(AtigDataJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("cisaData", targetDepth)) {
                    context.nextToken();
                    vulnerability.setCisaData(CisaDataJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("cvss2", targetDepth)) {
                    context.nextToken();
                    vulnerability.setCvss2(Cvss2JsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("cvss3", targetDepth)) {
                    context.nextToken();
                    vulnerability.setCvss3(Cvss3JsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("cwes", targetDepth)) {
                    context.nextToken();
                    vulnerability.setCwes(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    vulnerability.setDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("detectionPlatforms", targetDepth)) {
                    context.nextToken();
                    vulnerability.setDetectionPlatforms(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("epss", targetDepth)) {
                    context.nextToken();
                    vulnerability.setEpss(EpssJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("exploitObserved", targetDepth)) {
                    context.nextToken();
                    vulnerability.setExploitObserved(ExploitObservedJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    vulnerability.setId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("referenceUrls", targetDepth)) {
                    context.nextToken();
                    vulnerability.setReferenceUrls(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("relatedVulnerabilities", targetDepth)) {
                    context.nextToken();
                    vulnerability.setRelatedVulnerabilities(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("source", targetDepth)) {
                    context.nextToken();
                    vulnerability.setSource(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("sourceUrl", targetDepth)) {
                    context.nextToken();
                    vulnerability.setSourceUrl(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("vendorCreatedAt", targetDepth)) {
                    context.nextToken();
                    vulnerability.setVendorCreatedAt(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("vendorSeverity", targetDepth)) {
                    context.nextToken();
                    vulnerability.setVendorSeverity(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("vendorUpdatedAt", targetDepth)) {
                    context.nextToken();
                    vulnerability.setVendorUpdatedAt(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return vulnerability;
    }

    private static VulnerabilityJsonUnmarshaller instance;

    public static VulnerabilityJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new VulnerabilityJsonUnmarshaller();
        return instance;
    }
}
