/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.inspector2.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Details about the Exploit Prediction Scoring System (EPSS) score.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Epss" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Epss implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Exploit Prediction Scoring System (EPSS) score.
     * </p>
     */
    private Double score;

    /**
     * <p>
     * The Exploit Prediction Scoring System (EPSS) score.
     * </p>
     * 
     * @param score
     *        The Exploit Prediction Scoring System (EPSS) score.
     */

    public void setScore(Double score) {
        this.score = score;
    }

    /**
     * <p>
     * The Exploit Prediction Scoring System (EPSS) score.
     * </p>
     * 
     * @return The Exploit Prediction Scoring System (EPSS) score.
     */

    public Double getScore() {
        return this.score;
    }

    /**
     * <p>
     * The Exploit Prediction Scoring System (EPSS) score.
     * </p>
     * 
     * @param score
     *        The Exploit Prediction Scoring System (EPSS) score.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Epss withScore(Double score) {
        setScore(score);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getScore() != null)
            sb.append("Score: ").append(getScore());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Epss == false)
            return false;
        Epss other = (Epss) obj;
        if (other.getScore() == null ^ this.getScore() == null)
            return false;
        if (other.getScore() != null && other.getScore().equals(this.getScore()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getScore() == null) ? 0 : getScore().hashCode());
        return hashCode;
    }

    @Override
    public Epss clone() {
        try {
            return (Epss) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.inspector2.model.transform.EpssMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
