/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.inspector.AmazonInspector;
import com.amazonaws.services.inspector.model.AccessDeniedException;
import com.amazonaws.services.inspector.model.AddAttributesToFindingsRequest;
import com.amazonaws.services.inspector.model.AddAttributesToFindingsResult;
import com.amazonaws.services.inspector.model.AttachAssessmentAndRulesPackageRequest;
import com.amazonaws.services.inspector.model.AttachAssessmentAndRulesPackageResult;
import com.amazonaws.services.inspector.model.CreateApplicationRequest;
import com.amazonaws.services.inspector.model.CreateApplicationResult;
import com.amazonaws.services.inspector.model.CreateAssessmentRequest;
import com.amazonaws.services.inspector.model.CreateAssessmentResult;
import com.amazonaws.services.inspector.model.CreateResourceGroupRequest;
import com.amazonaws.services.inspector.model.CreateResourceGroupResult;
import com.amazonaws.services.inspector.model.DeleteApplicationRequest;
import com.amazonaws.services.inspector.model.DeleteApplicationResult;
import com.amazonaws.services.inspector.model.DeleteAssessmentRequest;
import com.amazonaws.services.inspector.model.DeleteAssessmentResult;
import com.amazonaws.services.inspector.model.DeleteRunRequest;
import com.amazonaws.services.inspector.model.DeleteRunResult;
import com.amazonaws.services.inspector.model.DescribeApplicationRequest;
import com.amazonaws.services.inspector.model.DescribeApplicationResult;
import com.amazonaws.services.inspector.model.DescribeAssessmentRequest;
import com.amazonaws.services.inspector.model.DescribeAssessmentResult;
import com.amazonaws.services.inspector.model.DescribeCrossAccountAccessRoleRequest;
import com.amazonaws.services.inspector.model.DescribeCrossAccountAccessRoleResult;
import com.amazonaws.services.inspector.model.DescribeFindingRequest;
import com.amazonaws.services.inspector.model.DescribeFindingResult;
import com.amazonaws.services.inspector.model.DescribeResourceGroupRequest;
import com.amazonaws.services.inspector.model.DescribeResourceGroupResult;
import com.amazonaws.services.inspector.model.DescribeRulesPackageRequest;
import com.amazonaws.services.inspector.model.DescribeRulesPackageResult;
import com.amazonaws.services.inspector.model.DescribeRunRequest;
import com.amazonaws.services.inspector.model.DescribeRunResult;
import com.amazonaws.services.inspector.model.DetachAssessmentAndRulesPackageRequest;
import com.amazonaws.services.inspector.model.DetachAssessmentAndRulesPackageResult;
import com.amazonaws.services.inspector.model.GetAssessmentTelemetryRequest;
import com.amazonaws.services.inspector.model.GetAssessmentTelemetryResult;
import com.amazonaws.services.inspector.model.InternalException;
import com.amazonaws.services.inspector.model.InvalidCrossAccountRoleException;
import com.amazonaws.services.inspector.model.InvalidInputException;
import com.amazonaws.services.inspector.model.ListApplicationsRequest;
import com.amazonaws.services.inspector.model.ListApplicationsResult;
import com.amazonaws.services.inspector.model.ListAssessmentAgentsRequest;
import com.amazonaws.services.inspector.model.ListAssessmentAgentsResult;
import com.amazonaws.services.inspector.model.ListAssessmentsRequest;
import com.amazonaws.services.inspector.model.ListAssessmentsResult;
import com.amazonaws.services.inspector.model.ListAttachedAssessmentsRequest;
import com.amazonaws.services.inspector.model.ListAttachedAssessmentsResult;
import com.amazonaws.services.inspector.model.ListAttachedRulesPackagesRequest;
import com.amazonaws.services.inspector.model.ListAttachedRulesPackagesResult;
import com.amazonaws.services.inspector.model.ListFindingsRequest;
import com.amazonaws.services.inspector.model.ListFindingsResult;
import com.amazonaws.services.inspector.model.ListRulesPackagesRequest;
import com.amazonaws.services.inspector.model.ListRulesPackagesResult;
import com.amazonaws.services.inspector.model.ListRunsRequest;
import com.amazonaws.services.inspector.model.ListRunsResult;
import com.amazonaws.services.inspector.model.ListTagsForResourceRequest;
import com.amazonaws.services.inspector.model.ListTagsForResourceResult;
import com.amazonaws.services.inspector.model.LocalizeTextRequest;
import com.amazonaws.services.inspector.model.LocalizeTextResult;
import com.amazonaws.services.inspector.model.NoSuchEntityException;
import com.amazonaws.services.inspector.model.OperationInProgressException;
import com.amazonaws.services.inspector.model.PreviewAgentsForResourceGroupRequest;
import com.amazonaws.services.inspector.model.PreviewAgentsForResourceGroupResult;
import com.amazonaws.services.inspector.model.RegisterCrossAccountAccessRoleRequest;
import com.amazonaws.services.inspector.model.RegisterCrossAccountAccessRoleResult;
import com.amazonaws.services.inspector.model.RemoveAttributesFromFindingsRequest;
import com.amazonaws.services.inspector.model.RemoveAttributesFromFindingsResult;
import com.amazonaws.services.inspector.model.RunAssessmentRequest;
import com.amazonaws.services.inspector.model.RunAssessmentResult;
import com.amazonaws.services.inspector.model.SetTagsForResourceRequest;
import com.amazonaws.services.inspector.model.SetTagsForResourceResult;
import com.amazonaws.services.inspector.model.StartDataCollectionRequest;
import com.amazonaws.services.inspector.model.StartDataCollectionResult;
import com.amazonaws.services.inspector.model.StopDataCollectionRequest;
import com.amazonaws.services.inspector.model.StopDataCollectionResult;
import com.amazonaws.services.inspector.model.UpdateApplicationRequest;
import com.amazonaws.services.inspector.model.UpdateApplicationResult;
import com.amazonaws.services.inspector.model.UpdateAssessmentRequest;
import com.amazonaws.services.inspector.model.UpdateAssessmentResult;
import com.amazonaws.services.inspector.model.transform.AddAttributesToFindingsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.AddAttributesToFindingsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.AttachAssessmentAndRulesPackageRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.AttachAssessmentAndRulesPackageResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.CreateApplicationRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.CreateApplicationResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.CreateAssessmentRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.CreateAssessmentResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.CreateResourceGroupRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.CreateResourceGroupResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteApplicationRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteApplicationResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteAssessmentRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteAssessmentResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteRunRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DeleteRunResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeApplicationRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeApplicationResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeAssessmentResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeCrossAccountAccessRoleRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeCrossAccountAccessRoleResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeFindingRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeFindingResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeResourceGroupRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeResourceGroupResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeRulesPackageRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeRulesPackageResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeRunRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DescribeRunResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.DetachAssessmentAndRulesPackageRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.DetachAssessmentAndRulesPackageResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.GetAssessmentTelemetryRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.GetAssessmentTelemetryResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListApplicationsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListApplicationsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentAgentsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentAgentsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListAssessmentsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListAttachedAssessmentsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListAttachedAssessmentsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListAttachedRulesPackagesRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListAttachedRulesPackagesResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListFindingsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListFindingsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListRulesPackagesRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListRulesPackagesResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListRunsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListRunsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.ListTagsForResourceRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.LocalizeTextRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.LocalizeTextResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.PreviewAgentsForResourceGroupRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.PreviewAgentsForResourceGroupResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.RegisterCrossAccountAccessRoleRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.RegisterCrossAccountAccessRoleResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.RemoveAttributesFromFindingsRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.RemoveAttributesFromFindingsResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.RunAssessmentRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.RunAssessmentResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.SetTagsForResourceRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.SetTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.StartDataCollectionRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.StartDataCollectionResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.StopDataCollectionRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.StopDataCollectionResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.UpdateApplicationRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.UpdateApplicationResultJsonUnmarshaller;
import com.amazonaws.services.inspector.model.transform.UpdateAssessmentRequestMarshaller;
import com.amazonaws.services.inspector.model.transform.UpdateAssessmentResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonInspectorClient
extends AmazonWebServiceClient
implements AmazonInspector {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonInspector.class);
    private static final String DEFAULT_SIGNING_NAME = "inspector";
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AmazonInspectorClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonInspectorClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonInspectorClient(AWSCredentials awsCredentials) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonInspectorClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonInspectorClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonInspectorClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonInspectorClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(NoSuchEntityException.class, "NoSuchEntityException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(OperationInProgressException.class, "OperationInProgressException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidInputException.class, "InvalidInputException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InternalException.class, "InternalException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(AccessDeniedException.class, "AccessDeniedException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidCrossAccountRoleException.class, "InvalidCrossAccountRoleException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setEndpoint("https://inspector.us-east-1.amazonaws.com");
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/inspector/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/inspector/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddAttributesToFindingsResult addAttributesToFindings(AddAttributesToFindingsRequest addAttributesToFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addAttributesToFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddAttributesToFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddAttributesToFindingsRequestMarshaller().marshall(addAttributesToFindingsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new AddAttributesToFindingsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            AddAttributesToFindingsResult addAttributesToFindingsResult = (AddAttributesToFindingsResult)response.getAwsResponse();
            return addAttributesToFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachAssessmentAndRulesPackageResult attachAssessmentAndRulesPackage(AttachAssessmentAndRulesPackageRequest attachAssessmentAndRulesPackageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(attachAssessmentAndRulesPackageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AttachAssessmentAndRulesPackageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AttachAssessmentAndRulesPackageRequestMarshaller().marshall(attachAssessmentAndRulesPackageRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new AttachAssessmentAndRulesPackageResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            AttachAssessmentAndRulesPackageResult attachAssessmentAndRulesPackageResult = (AttachAssessmentAndRulesPackageResult)response.getAwsResponse();
            return attachAssessmentAndRulesPackageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationResult createApplication(CreateApplicationRequest createApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateApplicationRequestMarshaller().marshall(createApplicationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateApplicationResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateApplicationResult createApplicationResult = (CreateApplicationResult)response.getAwsResponse();
            return createApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAssessmentResult createAssessment(CreateAssessmentRequest createAssessmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAssessmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAssessmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAssessmentRequestMarshaller().marshall(createAssessmentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateAssessmentResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateAssessmentResult createAssessmentResult = (CreateAssessmentResult)response.getAwsResponse();
            return createAssessmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateResourceGroupResult createResourceGroup(CreateResourceGroupRequest createResourceGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createResourceGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateResourceGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateResourceGroupRequestMarshaller().marshall(createResourceGroupRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateResourceGroupResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateResourceGroupResult createResourceGroupResult = (CreateResourceGroupResult)response.getAwsResponse();
            return createResourceGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationResult deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteApplicationRequestMarshaller().marshall(deleteApplicationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DeleteApplicationResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteApplicationResult deleteApplicationResult = (DeleteApplicationResult)response.getAwsResponse();
            return deleteApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAssessmentResult deleteAssessment(DeleteAssessmentRequest deleteAssessmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAssessmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAssessmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAssessmentRequestMarshaller().marshall(deleteAssessmentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DeleteAssessmentResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteAssessmentResult deleteAssessmentResult = (DeleteAssessmentResult)response.getAwsResponse();
            return deleteAssessmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRunResult deleteRun(DeleteRunRequest deleteRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRunRequestMarshaller().marshall(deleteRunRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DeleteRunResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteRunResult deleteRunResult = (DeleteRunResult)response.getAwsResponse();
            return deleteRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationResult describeApplication(DescribeApplicationRequest describeApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeApplicationRequestMarshaller().marshall(describeApplicationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeApplicationResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeApplicationResult describeApplicationResult = (DescribeApplicationResult)response.getAwsResponse();
            return describeApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAssessmentResult describeAssessment(DescribeAssessmentRequest describeAssessmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAssessmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAssessmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAssessmentRequestMarshaller().marshall(describeAssessmentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeAssessmentResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeAssessmentResult describeAssessmentResult = (DescribeAssessmentResult)response.getAwsResponse();
            return describeAssessmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCrossAccountAccessRoleResult describeCrossAccountAccessRole(DescribeCrossAccountAccessRoleRequest describeCrossAccountAccessRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeCrossAccountAccessRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeCrossAccountAccessRoleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeCrossAccountAccessRoleRequestMarshaller().marshall(describeCrossAccountAccessRoleRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeCrossAccountAccessRoleResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeCrossAccountAccessRoleResult describeCrossAccountAccessRoleResult = (DescribeCrossAccountAccessRoleResult)response.getAwsResponse();
            return describeCrossAccountAccessRoleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFindingResult describeFinding(DescribeFindingRequest describeFindingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFindingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFindingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFindingRequestMarshaller().marshall(describeFindingRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeFindingResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeFindingResult describeFindingResult = (DescribeFindingResult)response.getAwsResponse();
            return describeFindingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeResourceGroupResult describeResourceGroup(DescribeResourceGroupRequest describeResourceGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeResourceGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeResourceGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeResourceGroupRequestMarshaller().marshall(describeResourceGroupRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeResourceGroupResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeResourceGroupResult describeResourceGroupResult = (DescribeResourceGroupResult)response.getAwsResponse();
            return describeResourceGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRulesPackageResult describeRulesPackage(DescribeRulesPackageRequest describeRulesPackageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRulesPackageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRulesPackageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRulesPackageRequestMarshaller().marshall(describeRulesPackageRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeRulesPackageResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeRulesPackageResult describeRulesPackageResult = (DescribeRulesPackageResult)response.getAwsResponse();
            return describeRulesPackageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRunResult describeRun(DescribeRunRequest describeRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRunRequestMarshaller().marshall(describeRunRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeRunResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeRunResult describeRunResult = (DescribeRunResult)response.getAwsResponse();
            return describeRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachAssessmentAndRulesPackageResult detachAssessmentAndRulesPackage(DetachAssessmentAndRulesPackageRequest detachAssessmentAndRulesPackageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(detachAssessmentAndRulesPackageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DetachAssessmentAndRulesPackageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DetachAssessmentAndRulesPackageRequestMarshaller().marshall(detachAssessmentAndRulesPackageRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DetachAssessmentAndRulesPackageResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DetachAssessmentAndRulesPackageResult detachAssessmentAndRulesPackageResult = (DetachAssessmentAndRulesPackageResult)response.getAwsResponse();
            return detachAssessmentAndRulesPackageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAssessmentTelemetryResult getAssessmentTelemetry(GetAssessmentTelemetryRequest getAssessmentTelemetryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAssessmentTelemetryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAssessmentTelemetryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAssessmentTelemetryRequestMarshaller().marshall(getAssessmentTelemetryRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetAssessmentTelemetryResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetAssessmentTelemetryResult getAssessmentTelemetryResult = (GetAssessmentTelemetryResult)response.getAwsResponse();
            return getAssessmentTelemetryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationsResult listApplications(ListApplicationsRequest listApplicationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listApplicationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListApplicationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListApplicationsRequestMarshaller().marshall(listApplicationsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListApplicationsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListApplicationsResult listApplicationsResult = (ListApplicationsResult)response.getAwsResponse();
            return listApplicationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentAgentsResult listAssessmentAgents(ListAssessmentAgentsRequest listAssessmentAgentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssessmentAgentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssessmentAgentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssessmentAgentsRequestMarshaller().marshall(listAssessmentAgentsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListAssessmentAgentsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListAssessmentAgentsResult listAssessmentAgentsResult = (ListAssessmentAgentsResult)response.getAwsResponse();
            return listAssessmentAgentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssessmentsResult listAssessments(ListAssessmentsRequest listAssessmentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssessmentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssessmentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssessmentsRequestMarshaller().marshall(listAssessmentsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListAssessmentsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListAssessmentsResult listAssessmentsResult = (ListAssessmentsResult)response.getAwsResponse();
            return listAssessmentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAttachedAssessmentsResult listAttachedAssessments(ListAttachedAssessmentsRequest listAttachedAssessmentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAttachedAssessmentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAttachedAssessmentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAttachedAssessmentsRequestMarshaller().marshall(listAttachedAssessmentsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListAttachedAssessmentsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListAttachedAssessmentsResult listAttachedAssessmentsResult = (ListAttachedAssessmentsResult)response.getAwsResponse();
            return listAttachedAssessmentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAttachedRulesPackagesResult listAttachedRulesPackages(ListAttachedRulesPackagesRequest listAttachedRulesPackagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAttachedRulesPackagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAttachedRulesPackagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAttachedRulesPackagesRequestMarshaller().marshall(listAttachedRulesPackagesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListAttachedRulesPackagesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListAttachedRulesPackagesResult listAttachedRulesPackagesResult = (ListAttachedRulesPackagesResult)response.getAwsResponse();
            return listAttachedRulesPackagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFindingsResult listFindings(ListFindingsRequest listFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFindingsRequestMarshaller().marshall(listFindingsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListFindingsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListFindingsResult listFindingsResult = (ListFindingsResult)response.getAwsResponse();
            return listFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRulesPackagesResult listRulesPackages(ListRulesPackagesRequest listRulesPackagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRulesPackagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRulesPackagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRulesPackagesRequestMarshaller().marshall(listRulesPackagesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListRulesPackagesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListRulesPackagesResult listRulesPackagesResult = (ListRulesPackagesResult)response.getAwsResponse();
            return listRulesPackagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRunsResult listRuns(ListRunsRequest listRunsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRunsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRunsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRunsRequestMarshaller().marshall(listRunsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListRunsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListRunsResult listRunsResult = (ListRunsResult)response.getAwsResponse();
            return listRunsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestMarshaller().marshall(listTagsForResourceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalizeTextResult localizeText(LocalizeTextRequest localizeTextRequest) {
        ExecutionContext executionContext = this.createExecutionContext(localizeTextRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<LocalizeTextRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new LocalizeTextRequestMarshaller().marshall(localizeTextRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new LocalizeTextResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            LocalizeTextResult localizeTextResult = (LocalizeTextResult)response.getAwsResponse();
            return localizeTextResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreviewAgentsForResourceGroupResult previewAgentsForResourceGroup(PreviewAgentsForResourceGroupRequest previewAgentsForResourceGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(previewAgentsForResourceGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PreviewAgentsForResourceGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PreviewAgentsForResourceGroupRequestMarshaller().marshall(previewAgentsForResourceGroupRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new PreviewAgentsForResourceGroupResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PreviewAgentsForResourceGroupResult previewAgentsForResourceGroupResult = (PreviewAgentsForResourceGroupResult)response.getAwsResponse();
            return previewAgentsForResourceGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterCrossAccountAccessRoleResult registerCrossAccountAccessRole(RegisterCrossAccountAccessRoleRequest registerCrossAccountAccessRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerCrossAccountAccessRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterCrossAccountAccessRoleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterCrossAccountAccessRoleRequestMarshaller().marshall(registerCrossAccountAccessRoleRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new RegisterCrossAccountAccessRoleResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RegisterCrossAccountAccessRoleResult registerCrossAccountAccessRoleResult = (RegisterCrossAccountAccessRoleResult)response.getAwsResponse();
            return registerCrossAccountAccessRoleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveAttributesFromFindingsResult removeAttributesFromFindings(RemoveAttributesFromFindingsRequest removeAttributesFromFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeAttributesFromFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveAttributesFromFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveAttributesFromFindingsRequestMarshaller().marshall(removeAttributesFromFindingsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new RemoveAttributesFromFindingsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RemoveAttributesFromFindingsResult removeAttributesFromFindingsResult = (RemoveAttributesFromFindingsResult)response.getAwsResponse();
            return removeAttributesFromFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunAssessmentResult runAssessment(RunAssessmentRequest runAssessmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(runAssessmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RunAssessmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RunAssessmentRequestMarshaller().marshall(runAssessmentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new RunAssessmentResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RunAssessmentResult runAssessmentResult = (RunAssessmentResult)response.getAwsResponse();
            return runAssessmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetTagsForResourceResult setTagsForResource(SetTagsForResourceRequest setTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetTagsForResourceRequestMarshaller().marshall(setTagsForResourceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new SetTagsForResourceResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            SetTagsForResourceResult setTagsForResourceResult = (SetTagsForResourceResult)response.getAwsResponse();
            return setTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDataCollectionResult startDataCollection(StartDataCollectionRequest startDataCollectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startDataCollectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartDataCollectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartDataCollectionRequestMarshaller().marshall(startDataCollectionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new StartDataCollectionResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            StartDataCollectionResult startDataCollectionResult = (StartDataCollectionResult)response.getAwsResponse();
            return startDataCollectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopDataCollectionResult stopDataCollection(StopDataCollectionRequest stopDataCollectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopDataCollectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopDataCollectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopDataCollectionRequestMarshaller().marshall(stopDataCollectionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new StopDataCollectionResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            StopDataCollectionResult stopDataCollectionResult = (StopDataCollectionResult)response.getAwsResponse();
            return stopDataCollectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationResult updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateApplicationRequestMarshaller().marshall(updateApplicationRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateApplicationResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateApplicationResult updateApplicationResult = (UpdateApplicationResult)response.getAwsResponse();
            return updateApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAssessmentResult updateAssessment(UpdateAssessmentRequest updateAssessmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAssessmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAssessmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAssessmentRequestMarshaller().marshall(updateAssessmentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateAssessmentResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateAssessmentResult updateAssessmentResult = (UpdateAssessmentResult)response.getAwsResponse();
            return updateAssessmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

